/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.dirichlet;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.dirichlet.DirichletCluster;
import org.apache.mahout.clustering.dirichlet.DirichletClusterer;
import org.apache.mahout.clustering.dirichlet.DirichletMapper;
import org.apache.mahout.clustering.dirichlet.DirichletState;
import org.apache.mahout.math.VectorWritable;

public class DirichletReducer
extends Reducer<Text, VectorWritable, Text, DirichletCluster> {
    private DirichletClusterer clusterer;
    private Cluster[] newModels;

    public Cluster[] getNewModels() {
        return this.newModels;
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        DirichletState state = DirichletMapper.getDirichletState(context.getConfiguration());
        this.clusterer = new DirichletClusterer(state);
        List<DirichletCluster> oldModels = state.getClusters();
        for (DirichletCluster cluster : oldModels) {
            cluster.getModel().configure(context.getConfiguration());
        }
        for (Cluster cluster : this.newModels = (Cluster[])state.getModelFactory().sampleFromPosterior(state.getModels())) {
            cluster.configure(context.getConfiguration());
        }
    }

    protected void reduce(Text key, Iterable<VectorWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        int k = Integer.parseInt(key.toString());
        Cluster model = this.newModels[k];
        for (VectorWritable value : values) {
            if (value.get().size() <= 0) continue;
            model.observe(value);
        }
        DirichletCluster cluster = this.clusterer.updateCluster(model, k);
        context.write((Object)new Text(String.valueOf(k)), (Object)cluster);
    }

    public void setup(DirichletState state) {
        this.clusterer = new DirichletClusterer(state);
        List<DirichletCluster> oldModels = state.getClusters();
        for (DirichletCluster cluster : oldModels) {
            cluster.getModel().configure(new Configuration());
        }
        for (Cluster cluster : this.newModels = (Cluster[])state.getModelFactory().sampleFromPosterior(state.getModels())) {
            cluster.configure(new Configuration());
        }
    }
}

