/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.dirichlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.Model;
import org.apache.mahout.clustering.ModelDistribution;
import org.apache.mahout.clustering.WeightedVectorWritable;
import org.apache.mahout.clustering.dirichlet.DirichletCluster;
import org.apache.mahout.clustering.dirichlet.DirichletState;
import org.apache.mahout.clustering.dirichlet.UncommonDistributions;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class DirichletClusterer {
    private final List<VectorWritable> sampleData;
    private final ModelDistribution<VectorWritable> modelFactory;
    private final DirichletState state;
    private final int thin;
    private final int burnin;
    private final int numClusters;
    private final List<Cluster[]> clusterSamples = new ArrayList<Cluster[]>();
    private boolean emitMostLikely;
    private double threshold;

    public static List<Cluster[]> clusterPoints(List<VectorWritable> points, ModelDistribution<VectorWritable> modelFactory, double alpha0, int numClusters, int thin, int burnin, int numIterations) {
        DirichletClusterer clusterer = new DirichletClusterer(points, modelFactory, alpha0, numClusters, thin, burnin);
        return clusterer.cluster(numIterations);
    }

    public DirichletClusterer(List<VectorWritable> sampleData, ModelDistribution<VectorWritable> modelFactory, double alpha0, int numClusters, int thin, int burnin) {
        this.sampleData = sampleData;
        this.modelFactory = modelFactory;
        this.thin = thin;
        this.burnin = burnin;
        this.numClusters = numClusters;
        this.state = new DirichletState(modelFactory, numClusters, alpha0);
    }

    public DirichletClusterer(boolean emitMostLikely, double threshold) {
        this.sampleData = null;
        this.modelFactory = null;
        this.thin = 0;
        this.burnin = 0;
        this.numClusters = 0;
        this.state = null;
        this.emitMostLikely = emitMostLikely;
        this.threshold = threshold;
    }

    public DirichletClusterer(DirichletState state) {
        this.state = state;
        this.modelFactory = state.getModelFactory();
        this.sampleData = null;
        this.numClusters = state.getNumClusters();
        this.thin = 0;
        this.burnin = 0;
    }

    public List<Cluster[]> cluster(int numIterations) {
        for (int iteration = 0; iteration < numIterations; ++iteration) {
            this.iterate(iteration);
        }
        return this.clusterSamples;
    }

    private void iterate(int iteration) {
        Cluster[] newModels = (Cluster[])this.modelFactory.sampleFromPosterior(this.state.getModels());
        for (VectorWritable observation : this.sampleData) {
            this.observe(newModels, observation);
        }
        if (iteration >= this.burnin && iteration % this.thin == 0) {
            this.clusterSamples.add(newModels);
        }
        this.state.update(newModels);
    }

    protected void observe(Model<VectorWritable>[] newModels, VectorWritable observation) {
        int k = this.assignToModel(observation);
        newModels[k].observe(observation);
    }

    protected int assignToModel(VectorWritable observation) {
        DenseVector pi = new DenseVector(this.numClusters);
        for (int k1 = 0; k1 < this.numClusters; ++k1) {
            pi.set(k1, this.state.adjustedProbability(observation, k1));
        }
        return UncommonDistributions.rMultinom((Vector)pi);
    }

    protected void updateModels(Cluster[] newModels) {
        this.state.update(newModels);
    }

    protected Model<VectorWritable>[] samplePosteriorModels() {
        return this.state.getModelFactory().sampleFromPosterior(this.state.getModels());
    }

    protected DirichletCluster updateCluster(Cluster model, int k) {
        model.computeParameters();
        DirichletCluster cluster = this.state.getClusters().get(k);
        cluster.setModel(model);
        return cluster;
    }

    public void emitPointToClusters(VectorWritable vector, List<DirichletCluster> clusters, Mapper.Context context) throws IOException, InterruptedException {
        DenseVector pi = new DenseVector(clusters.size());
        for (int i = 0; i < clusters.size(); ++i) {
            pi.set(i, clusters.get(i).getModel().pdf(vector));
        }
        pi = pi.divide(pi.zSum());
        if (this.emitMostLikely) {
            this.emitMostLikelyCluster(vector, clusters, (Vector)pi, context);
        } else {
            this.emitAllClusters(vector, clusters, (Vector)pi, context);
        }
    }

    private void emitMostLikelyCluster(VectorWritable point, Collection<DirichletCluster> clusters, Vector pi, Mapper.Context context) throws IOException, InterruptedException {
        int clusterId = -1;
        double clusterPdf = 0.0;
        for (int i = 0; i < clusters.size(); ++i) {
            double pdf = pi.get(i);
            if (!(pdf > clusterPdf)) continue;
            clusterId = i;
            clusterPdf = pdf;
        }
        context.write((Object)new IntWritable(clusterId), (Object)new WeightedVectorWritable(clusterPdf, point.get()));
    }

    private void emitAllClusters(VectorWritable point, List<DirichletCluster> clusters, Vector pi, Mapper.Context context) throws IOException, InterruptedException {
        for (int i = 0; i < clusters.size(); ++i) {
            double pdf = pi.get(i);
            if (!(pdf > this.threshold) || !(clusters.get(i).getTotalCount() > 0.0)) continue;
            context.write((Object)new IntWritable(i), (Object)new WeightedVectorWritable(pdf, point.get()));
        }
    }

    public void emitPointToClusters(VectorWritable vector, List<DirichletCluster> clusters, SequenceFile.Writer writer) throws IOException {
        DenseVector pi = new DenseVector(clusters.size());
        for (int i = 0; i < clusters.size(); ++i) {
            double pdf = clusters.get(i).getModel().pdf(vector);
            pi.set(i, pdf);
        }
        pi = pi.divide(pi.zSum());
        if (this.emitMostLikely) {
            DirichletClusterer.emitMostLikelyCluster(vector, clusters, (Vector)pi, writer);
        } else {
            this.emitAllClusters(vector, clusters, (Vector)pi, writer);
        }
    }

    private void emitAllClusters(VectorWritable vector, List<DirichletCluster> clusters, Vector pi, SequenceFile.Writer writer) throws IOException {
        for (int i = 0; i < clusters.size(); ++i) {
            double pdf = pi.get(i);
            if (!(pdf > this.threshold) || !(clusters.get(i).getTotalCount() > 0.0)) continue;
            writer.append((Writable)new IntWritable(i), (Writable)new WeightedVectorWritable(pdf, vector.get()));
        }
    }

    private static void emitMostLikelyCluster(VectorWritable vector, Collection<DirichletCluster> clusters, Vector pi, SequenceFile.Writer writer) throws IOException {
        double maxPdf = 0.0;
        int clusterId = -1;
        for (int i = 0; i < clusters.size(); ++i) {
            double pdf = pi.get(i);
            if (!(pdf > maxPdf)) continue;
            maxPdf = pdf;
            clusterId = i;
        }
        writer.append((Writable)new IntWritable(clusterId), (Writable)new WeightedVectorWritable(maxPdf, vector.get()));
    }
}

