/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.dirichlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.WeightedVectorWritable;
import org.apache.mahout.clustering.dirichlet.DirichletCluster;
import org.apache.mahout.clustering.dirichlet.DirichletClusterer;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterable;
import org.apache.mahout.math.VectorWritable;

public class DirichletClusterMapper
extends Mapper<WritableComparable<?>, VectorWritable, IntWritable, WeightedVectorWritable> {
    private List<DirichletCluster> clusters;
    private DirichletClusterer clusterer;

    protected void map(WritableComparable<?> key, VectorWritable vector, Mapper.Context context) throws IOException, InterruptedException {
        this.clusterer.emitPointToClusters(vector, this.clusters, context);
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        this.clusters = DirichletClusterMapper.getClusters(conf);
        for (DirichletCluster cluster : this.clusters) {
            cluster.getModel().configure(conf);
        }
        String emitMostLikely = conf.get("org.apache.mahout.clustering.dirichlet.emitMostLikely");
        String threshold = conf.get("org.apache.mahout.clustering.dirichlet.threshold");
        this.clusterer = new DirichletClusterer(Boolean.parseBoolean(emitMostLikely), Double.parseDouble(threshold));
    }

    public static List<DirichletCluster> getClusters(Configuration conf) {
        String statePath = conf.get("org.apache.mahout.clustering.dirichlet.stateIn");
        return DirichletClusterMapper.loadClusters(conf, new Path(statePath));
    }

    protected static List<DirichletCluster> loadClusters(Configuration conf, Path stateIn) {
        ArrayList<DirichletCluster> clusters = new ArrayList<DirichletCluster>();
        for (DirichletCluster value : new SequenceFileDirValueIterable(stateIn, PathType.LIST, PathFilters.logsCRCFilter(), conf)) {
            clusters.add(value);
        }
        return clusters;
    }
}

