/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.dirichlet;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.Model;
import org.apache.mahout.common.parameters.Parameter;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class DirichletCluster
implements Cluster {
    private Cluster model;
    private double totalCount;

    public DirichletCluster(Cluster model, double totalCount) {
        this.model = model;
        this.totalCount = totalCount;
    }

    public DirichletCluster(Cluster model) {
        this.model = model;
        this.totalCount = 0.0;
    }

    public DirichletCluster() {
    }

    @Override
    public void configure(Configuration job) {
    }

    @Override
    public Collection<Parameter<?>> getParameters() {
        return Collections.emptyList();
    }

    @Override
    public void createParameters(String prefix, Configuration jobConf) {
    }

    public Cluster getModel() {
        return this.model;
    }

    public void setModel(Cluster model) {
        this.model = model;
        this.totalCount += (double)model.count();
    }

    public double getTotalCount() {
        return this.totalCount;
    }

    public void readFields(DataInput in) throws IOException {
        this.totalCount = in.readDouble();
        this.model = DirichletCluster.readModel(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.totalCount);
        DirichletCluster.writeModel(out, this.model);
    }

    public static void writeModel(DataOutput out, Model<?> model) throws IOException {
        out.writeUTF(model.getClass().getName());
        model.write(out);
    }

    public static Cluster readModel(DataInput in) throws IOException {
        Cluster model;
        String modelClassName = in.readUTF();
        try {
            model = Class.forName(modelClassName).asSubclass(Cluster.class).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        model.readFields(in);
        return model;
    }

    @Override
    public String asFormatString(String[] bindings) {
        return "C-" + this.model.getId() + ": " + this.model.asFormatString(bindings);
    }

    @Override
    public int getId() {
        return this.model.getId();
    }

    @Override
    public Vector getCenter() {
        return this.model.getCenter();
    }

    @Override
    public long getNumPoints() {
        return this.model.getNumPoints();
    }

    @Override
    public Vector getRadius() {
        return this.model.getRadius();
    }

    @Override
    public void computeParameters() {
        this.model.computeParameters();
    }

    @Override
    public long count() {
        return this.model.count();
    }

    @Override
    public void observe(VectorWritable x) {
        this.model.observe(x);
    }

    @Override
    public double pdf(VectorWritable x) {
        return this.model.pdf(x);
    }

    @Override
    public Model<VectorWritable> sampleFromPosterior() {
        return this.model.sampleFromPosterior();
    }

    @Override
    public void observe(VectorWritable x, double weight) {
        throw new UnsupportedOperationException();
    }
}

