/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.canopy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.WeightedVectorWritable;
import org.apache.mahout.clustering.canopy.Canopy;
import org.apache.mahout.clustering.canopy.CanopyClusterer;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class ClusterMapper
extends Mapper<WritableComparable<?>, VectorWritable, IntWritable, WeightedVectorWritable> {
    private CanopyClusterer canopyClusterer;
    private final Collection<Canopy> canopies = new ArrayList<Canopy>();

    protected void map(WritableComparable<?> key, VectorWritable point, Mapper.Context context) throws IOException, InterruptedException {
        this.canopyClusterer.emitPointToClosestCanopy(point.get(), this.canopies, context);
    }

    public void config(Collection<Canopy> canopies) {
        this.canopies.clear();
        this.canopies.addAll(canopies);
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.canopyClusterer = new CanopyClusterer(context.getConfiguration());
        Configuration conf = context.getConfiguration();
        String clustersIn = conf.get("org.apache.mahout.clustering.canopy.path");
        if (clustersIn != null && clustersIn.length() > 0) {
            Path clusterPath = new Path(clustersIn, "*");
            FileSystem fs = clusterPath.getFileSystem(conf);
            Path[] paths = FileUtil.stat2Paths((FileStatus[])fs.globStatus(clusterPath, PathFilters.partFilter()));
            for (FileStatus file : fs.listStatus(paths, PathFilters.partFilter())) {
                for (Canopy value : new SequenceFileValueIterable(file.getPath(), conf)) {
                    this.canopies.add(value);
                }
            }
            if (this.canopies.isEmpty()) {
                throw new IllegalStateException("Canopies are empty!");
            }
        }
    }

    public boolean canopyCovers(Canopy canopy, Vector point) {
        return this.canopyClusterer.canopyCovers(canopy, point);
    }
}

