/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.canopy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.clustering.canopy.Canopy;
import org.apache.mahout.clustering.canopy.CanopyClusterer;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class CanopyReducer
extends Reducer<Text, VectorWritable, Text, Canopy> {
    private final Collection<Canopy> canopies = new ArrayList<Canopy>();
    private CanopyClusterer canopyClusterer;

    CanopyClusterer getCanopyClusterer() {
        return this.canopyClusterer;
    }

    protected void reduce(Text arg0, Iterable<VectorWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        for (VectorWritable value : values) {
            Vector point = value.get();
            this.canopyClusterer.addPointToCanopies(point, this.canopies);
        }
        for (Canopy canopy : this.canopies) {
            canopy.computeParameters();
            context.write((Object)new Text(canopy.getIdentifier()), (Object)canopy);
        }
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.canopyClusterer = new CanopyClusterer(context.getConfiguration());
        this.canopyClusterer.useT3T4();
    }
}

