/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.canopy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.canopy.Canopy;
import org.apache.mahout.clustering.canopy.CanopyClusterer;
import org.apache.mahout.math.VectorWritable;

class CanopyMapper
extends Mapper<WritableComparable<?>, VectorWritable, Text, VectorWritable> {
    private final Collection<Canopy> canopies = new ArrayList<Canopy>();
    private CanopyClusterer canopyClusterer;

    CanopyMapper() {
    }

    protected void map(WritableComparable<?> key, VectorWritable point, Mapper.Context context) throws IOException, InterruptedException {
        this.canopyClusterer.addPointToCanopies(point.get(), this.canopies);
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.canopyClusterer = new CanopyClusterer(context.getConfiguration());
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        for (Canopy canopy : this.canopies) {
            context.write((Object)new Text("centroid"), (Object)new VectorWritable(canopy.computeCentroid()));
        }
        super.cleanup(context);
    }
}

