/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.canopy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.AbstractCluster;
import org.apache.mahout.clustering.WeightedVectorWritable;
import org.apache.mahout.clustering.canopy.Canopy;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanopyClusterer {
    private static final Logger log = LoggerFactory.getLogger(CanopyClusterer.class);
    private int nextCanopyId;
    private double t1;
    private double t2;
    private double t3;
    private double t4;
    private DistanceMeasure measure;

    public CanopyClusterer(DistanceMeasure measure, double t1, double t2) {
        this.t1 = t1;
        this.t2 = t2;
        this.t3 = t1;
        this.t4 = t2;
        this.measure = measure;
    }

    public double getT1() {
        return this.t1;
    }

    public double getT2() {
        return this.t2;
    }

    public double getT3() {
        return this.t3;
    }

    public double getT4() {
        return this.t4;
    }

    public CanopyClusterer(Configuration config) {
        this.configure(config);
    }

    public void configure(Configuration configuration) {
        try {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            this.measure = ccl.loadClass(configuration.get("org.apache.mahout.clustering.canopy.measure")).asSubclass(DistanceMeasure.class).newInstance();
            this.measure.configure(configuration);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        this.t1 = Double.parseDouble(configuration.get("org.apache.mahout.clustering.canopy.t1"));
        this.t2 = Double.parseDouble(configuration.get("org.apache.mahout.clustering.canopy.t2"));
        this.t3 = this.t1;
        String d = configuration.get("org.apache.mahout.clustering.canopy.t3");
        if (d != null) {
            this.t3 = Double.parseDouble(d);
        }
        this.t4 = this.t2;
        d = configuration.get("org.apache.mahout.clustering.canopy.t4");
        if (d != null) {
            this.t4 = Double.parseDouble(d);
        }
        this.nextCanopyId = 0;
    }

    public void useT3T4() {
        this.t1 = this.t3;
        this.t2 = this.t4;
    }

    public void config(DistanceMeasure aMeasure, double aT1, double aT2) {
        this.measure = aMeasure;
        this.t1 = aT1;
        this.t2 = aT2;
        this.t3 = this.t1;
        this.t4 = this.t2;
    }

    public void addPointToCanopies(Vector point, Collection<Canopy> canopies) {
        boolean pointStronglyBound = false;
        for (Canopy canopy : canopies) {
            double dist = this.measure.distance(canopy.getCenter().getLengthSquared(), canopy.getCenter(), point);
            if (dist < this.t1) {
                log.debug("Added point: {} to canopy: {}", (Object)AbstractCluster.formatVector(point, null), (Object)canopy.getIdentifier());
                canopy.observe(point);
            }
            pointStronglyBound = pointStronglyBound || dist < this.t2;
        }
        if (!pointStronglyBound) {
            log.debug("Created new Canopy:{} at center:{}", (Object)this.nextCanopyId, (Object)AbstractCluster.formatVector(point, null));
            canopies.add(new Canopy(point, this.nextCanopyId++, this.measure));
        }
    }

    public void emitPointToClosestCanopy(Vector point, Iterable<Canopy> canopies, Mapper.Context context) throws IOException, InterruptedException {
        Canopy closest = this.findClosestCanopy(point, canopies);
        context.write((Object)new IntWritable(closest.getId()), (Object)new WeightedVectorWritable(1.0, point));
        context.setStatus("Emit Closest Canopy ID:" + closest.getIdentifier());
    }

    protected Canopy findClosestCanopy(Vector point, Iterable<Canopy> canopies) {
        double minDist = Double.MAX_VALUE;
        Canopy closest = null;
        for (Canopy canopy : canopies) {
            double dist = this.measure.distance(canopy.getCenter().getLengthSquared(), canopy.getCenter(), point);
            if (!(dist < minDist)) continue;
            minDist = dist;
            closest = canopy;
        }
        return closest;
    }

    public boolean canopyCovers(Canopy canopy, Vector point) {
        return this.measure.distance(canopy.getCenter().getLengthSquared(), canopy.getCenter(), point) < this.t1;
    }

    public static List<Canopy> createCanopies(List<Vector> points, DistanceMeasure measure, double t1, double t2) {
        ArrayList<Canopy> canopies = new ArrayList<Canopy>();
        int nextCanopyId = 0;
        while (!points.isEmpty()) {
            Iterator<Vector> ptIter = points.iterator();
            Vector p1 = ptIter.next();
            ptIter.remove();
            Canopy canopy = new Canopy(p1, nextCanopyId++, measure);
            canopies.add(canopy);
            while (ptIter.hasNext()) {
                Vector p2 = ptIter.next();
                double dist = measure.distance(p1, p2);
                if (dist < t1) {
                    canopy.observe(p2);
                }
                if (!(dist < t2)) continue;
                ptIter.remove();
            }
            for (Canopy c : canopies) {
                c.computeParameters();
            }
        }
        return canopies;
    }

    public static List<Vector> getCenters(Iterable<Canopy> canopies) {
        ArrayList<Vector> result = new ArrayList<Vector>();
        for (Canopy canopy : canopies) {
            result.add(canopy.getCenter());
        }
        return result;
    }

    public static void updateCentroids(Iterable<Canopy> canopies) {
        for (Canopy canopy : canopies) {
            canopy.computeParameters();
        }
    }
}

