/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.clustering.AbstractCluster;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public final class WeightedVectorWritable
implements Writable {
    private final VectorWritable vectorWritable = new VectorWritable();
    private double weight;

    public WeightedVectorWritable() {
    }

    public WeightedVectorWritable(double weight, Vector vector) {
        this.vectorWritable.set(vector);
        this.weight = weight;
    }

    public Vector getVector() {
        return this.vectorWritable.get();
    }

    public void setVector(Vector vector) {
        this.vectorWritable.set(vector);
    }

    public double getWeight() {
        return this.weight;
    }

    public void readFields(DataInput in) throws IOException {
        this.vectorWritable.readFields(in);
        this.weight = in.readDouble();
    }

    public void write(DataOutput out) throws IOException {
        this.vectorWritable.write(out);
        out.writeDouble(this.weight);
    }

    public String toString() {
        Vector vector = this.vectorWritable.get();
        return this.weight + ": " + (vector == null ? "null" : AbstractCluster.formatVector(vector, null));
    }
}

