/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.mahout.clustering.AbstractCluster;
import org.apache.mahout.clustering.Model;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class DistanceMeasureCluster
extends AbstractCluster {
    private DistanceMeasure measure;

    public DistanceMeasureCluster(Vector point, int id, DistanceMeasure measure) {
        super(point, id);
        this.measure = measure;
    }

    public DistanceMeasureCluster() {
    }

    @Override
    public void configure(Configuration job) {
        if (this.getMeasure() != null) {
            this.getMeasure().configure(job);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        String dm = in.readUTF();
        try {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            this.measure = ccl.loadClass(dm).asSubclass(DistanceMeasure.class).newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        super.readFields(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.measure.getClass().getName());
        super.write(out);
    }

    @Override
    public double pdf(VectorWritable vw) {
        return Math.exp(-this.measure.distance(vw.get(), this.getCenter()));
    }

    @Override
    public Model<VectorWritable> sampleFromPosterior() {
        return new DistanceMeasureCluster(this.getCenter(), this.getId(), this.measure);
    }

    public DistanceMeasure getMeasure() {
        return this.measure;
    }

    public void setMeasure(DistanceMeasure measure) {
        this.measure = measure;
    }

    @Override
    public String getIdentifier() {
        return "DMC:" + this.getId();
    }
}

