/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering;

import org.apache.mahout.clustering.ClusterClassifier;
import org.apache.mahout.clustering.ClusteringPolicy;
import org.apache.mahout.clustering.dirichlet.UncommonDistributions;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;

public class DirichletClusteringPolicy
implements ClusteringPolicy {
    private Vector mixture;
    private final double alpha0;
    private final Vector totalCounts;

    public DirichletClusteringPolicy(int k, double alpha0) {
        this.totalCounts = new DenseVector(k);
        this.alpha0 = alpha0;
        this.mixture = UncommonDistributions.rDirichlet(this.totalCounts, alpha0);
    }

    @Override
    public Vector select(Vector probabilities) {
        int rMultinom = UncommonDistributions.rMultinom(probabilities.times(this.mixture));
        SequentialAccessSparseVector weights = new SequentialAccessSparseVector(probabilities.size());
        weights.set(rMultinom, 1.0);
        return weights;
    }

    @Override
    public void update(ClusterClassifier prior) {
        for (int i = 0; i < this.totalCounts.size(); ++i) {
            long nObserved = prior.getModels().get(i).getNumPoints();
            this.totalCounts.set(i, this.totalCounts.get(i) + (double)nObserved);
        }
        this.mixture = UncommonDistributions.rDirichlet(this.totalCounts, this.alpha0);
    }
}

