/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.clustering.AbstractCluster;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class ClusterObservations
implements Writable {
    private int combinerState;
    private double s0;
    private Vector s1;
    private Vector s2;

    public ClusterObservations(double s0, Vector s1, Vector s2) {
        this.s0 = s0;
        this.s1 = s1;
        this.s2 = s2;
    }

    public ClusterObservations(int combinerState, double s0, Vector s1, Vector s2) {
        this.combinerState = combinerState;
        this.s0 = s0;
        this.s1 = s1;
        this.s2 = s2;
    }

    public ClusterObservations() {
    }

    public void readFields(DataInput in) throws IOException {
        this.combinerState = in.readInt();
        this.s0 = in.readDouble();
        VectorWritable temp = new VectorWritable();
        temp.readFields(in);
        this.s1 = temp.get();
        temp.readFields(in);
        this.s2 = temp.get();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.combinerState);
        out.writeDouble(this.s0);
        VectorWritable.writeVector(out, this.s1);
        VectorWritable.writeVector(out, this.s2);
    }

    public int getCombinerState() {
        return this.combinerState;
    }

    public double getS0() {
        return this.s0;
    }

    public Vector getS1() {
        return this.s1;
    }

    public Vector getS2() {
        return this.s2;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(50);
        buf.append("co{s0=").append(this.s0).append(" s1=");
        if (this.s1 != null) {
            buf.append(AbstractCluster.formatVector(this.s1, null));
        }
        buf.append(" s2=");
        if (this.s2 != null) {
            buf.append(AbstractCluster.formatVector(this.s2, null));
        }
        buf.append('}');
        return buf.toString();
    }

    public ClusterObservations incrementCombinerState() {
        ++this.combinerState;
        return this;
    }
}

