/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering;

import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.clustering.ClusterClassifier;
import org.apache.mahout.clustering.ClusteringPolicy;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class ClusterIterator {
    private final ClusteringPolicy policy;

    public ClusterIterator(ClusteringPolicy policy) {
        this.policy = policy;
    }

    public ClusterClassifier iterate(Iterable<Vector> data, ClusterClassifier classifier, int numIterations) {
        for (int iteration = 1; iteration <= numIterations; ++iteration) {
            for (Vector vector : data) {
                Vector probabilities = classifier.classify(vector);
                Vector weights = this.policy.select(probabilities);
                Iterator it = weights.iterateNonZero();
                while (it.hasNext()) {
                    int index = ((Vector.Element)it.next()).index();
                    classifier.train(index, vector, weights.get(index));
                }
            }
            classifier.close();
            this.policy.update(classifier);
        }
        return classifier;
    }

    public void iterate(Path inPath, Path priorPath, Path outPath, int numIterations) throws IOException {
        ClusterClassifier classifier = ClusterIterator.readClassifier(priorPath);
        Configuration conf = new Configuration();
        for (int iteration = 1; iteration <= numIterations; ++iteration) {
            for (VectorWritable vw : new SequenceFileDirValueIterable(inPath, PathType.LIST, PathFilters.logsCRCFilter(), conf)) {
                Vector vector = vw.get();
                Vector probabilities = classifier.classify(vector);
                Vector weights = this.policy.select(probabilities);
                Iterator it = weights.iterateNonZero();
                while (it.hasNext()) {
                    int index = ((Vector.Element)it.next()).index();
                    classifier.train(index, vector, weights.get(index));
                }
            }
            classifier.close();
            this.policy.update(classifier);
            ClusterIterator.writeClassifier(classifier, new Path(outPath, "classifier-" + iteration), String.valueOf(iteration));
        }
    }

    private static void writeClassifier(ClusterClassifier classifier, Path outPath, String k) throws IOException {
        Configuration config = new Configuration();
        FileSystem fs = FileSystem.get((URI)outPath.toUri(), (Configuration)config);
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, config, outPath, Text.class, ClusterClassifier.class);
        Text key = new Text(k);
        writer.append((Writable)key, (Writable)classifier);
        writer.close();
    }

    private static ClusterClassifier readClassifier(Path inPath) throws IOException {
        Configuration config = new Configuration();
        FileSystem fs = FileSystem.get((URI)inPath.toUri(), (Configuration)config);
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, inPath, config);
        Text key = new Text();
        ClusterClassifier classifierOut = new ClusterClassifier();
        reader.next((Writable)key, (Writable)classifierOut);
        reader.close();
        return classifierOut;
    }
}

