/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.classifier.AbstractVectorClassifier;
import org.apache.mahout.classifier.OnlineLearner;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.fuzzykmeans.FuzzyKMeansClusterer;
import org.apache.mahout.clustering.fuzzykmeans.SoftCluster;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.TimesFunction;

public class ClusterClassifier
extends AbstractVectorClassifier
implements OnlineLearner,
Writable {
    private List<Cluster> models;
    private String modelClass;

    public ClusterClassifier(List<Cluster> models) {
        this.models = models;
        this.modelClass = models.get(0).getClass().getName();
    }

    public ClusterClassifier() {
    }

    @Override
    public Vector classify(Vector instance) {
        DenseVector pdfs = new DenseVector(this.models.size());
        if (this.models.get(0) instanceof SoftCluster) {
            ArrayList<SoftCluster> clusters = new ArrayList<SoftCluster>();
            ArrayList<Double> distances = new ArrayList<Double>();
            for (Cluster model : this.models) {
                SoftCluster sc = (SoftCluster)model;
                clusters.add(sc);
                distances.add(sc.getMeasure().distance(instance, sc.getCenter()));
            }
            return new FuzzyKMeansClusterer().computePi(clusters, distances);
        }
        int i = 0;
        for (Cluster model : this.models) {
            pdfs.set(i++, model.pdf(new VectorWritable(instance)));
        }
        return pdfs.assign((DoubleDoubleFunction)new TimesFunction(), 1.0 / pdfs.zSum());
    }

    @Override
    public double classifyScalar(Vector instance) {
        if (this.models.size() == 2) {
            double pdf0 = this.models.get(0).pdf(new VectorWritable(instance));
            double pdf1 = this.models.get(1).pdf(new VectorWritable(instance));
            return pdf0 / (pdf0 + pdf1);
        }
        throw new IllegalStateException();
    }

    @Override
    public int numCategories() {
        return this.models.size();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.models.size());
        out.writeUTF(this.modelClass);
        for (Cluster cluster : this.models) {
            cluster.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        this.modelClass = in.readUTF();
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Class<Cluster> factory = ccl.loadClass(this.modelClass).asSubclass(Cluster.class);
            this.models = new ArrayList<Cluster>();
            for (int i = 0; i < size; ++i) {
                Cluster element = factory.newInstance();
                element.readFields(in);
                this.models.add(element);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void train(int actual, Vector instance) {
        this.models.get(actual).observe(new VectorWritable(instance));
    }

    public void train(int actual, Vector data, double weight) {
        this.models.get(actual).observe(new VectorWritable(data), weight);
    }

    @Override
    public void train(long trackingKey, String groupKey, int actual, Vector instance) {
        this.models.get(actual).observe(new VectorWritable(instance));
    }

    @Override
    public void train(long trackingKey, int actual, Vector instance) {
        this.models.get(actual).observe(new VectorWritable(instance));
    }

    @Override
    public void close() {
        for (Cluster cluster : this.models) {
            cluster.computeParameters();
        }
    }

    public List<Cluster> getModels() {
        return this.models;
    }
}

