/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.ClusterObservations;
import org.apache.mahout.common.parameters.Parameter;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.SquareRootFunction;

public abstract class AbstractCluster
implements Cluster {
    private int id;
    private long numPoints;
    private Vector center;
    private Vector radius;
    private double s0;
    private Vector s1;
    private Vector s2;

    protected AbstractCluster() {
    }

    protected AbstractCluster(Vector point, int id2) {
        this.numPoints = 0L;
        this.center = new RandomAccessSparseVector(point);
        this.radius = point.like();
        this.id = id2;
    }

    protected AbstractCluster(Vector center2, Vector radius2, int id2) {
        this.numPoints = 0L;
        this.center = new RandomAccessSparseVector(center2);
        this.radius = new RandomAccessSparseVector(radius2);
        this.id = id2;
    }

    @Override
    public void configure(Configuration job) {
    }

    @Override
    public Collection<Parameter<?>> getParameters() {
        return Collections.emptyList();
    }

    @Override
    public void createParameters(String prefix, Configuration jobConf) {
    }

    protected void setId(int id) {
        this.id = id;
    }

    protected void setNumPoints(long l) {
        this.numPoints = l;
    }

    protected void setCenter(Vector center) {
        this.center = center;
    }

    protected void setRadius(Vector radius) {
        this.radius = radius;
    }

    protected double getS0() {
        return this.s0;
    }

    protected Vector getS1() {
        return this.s1;
    }

    protected Vector getS2() {
        return this.s2;
    }

    @Override
    public void observe(ClusterObservations observations) {
        this.s0 += observations.getS0();
        if (this.s1 == null) {
            this.s1 = observations.getS1().clone();
        } else {
            observations.getS1().addTo(this.s1);
        }
        if (this.s2 == null) {
            this.s2 = observations.getS2().clone();
        } else {
            observations.getS2().addTo(this.s2);
        }
    }

    @Override
    public void observe(VectorWritable x) {
        this.observe(x.get());
    }

    @Override
    public void observe(VectorWritable x, double weight) {
        this.observe(x.get(), weight);
    }

    @Override
    public void observe(Vector x, double weight) {
        if (weight == 1.0) {
            this.observe(x);
        } else {
            this.s0 += weight;
            Vector weightedX = x.times(weight);
            if (this.s1 == null) {
                this.s1 = weightedX;
            } else {
                weightedX.addTo(this.s1);
            }
            Vector x2 = x.times(x).times(weight);
            if (this.s2 == null) {
                this.s2 = x2;
            } else {
                x2.addTo(this.s2);
            }
        }
    }

    @Override
    public void observe(Vector x) {
        this.s0 += 1.0;
        if (this.s1 == null) {
            this.s1 = x.clone();
        } else {
            x.addTo(this.s1);
        }
        Vector x2 = x.times(x);
        if (this.s2 == null) {
            this.s2 = x2;
        } else {
            x2.addTo(this.s2);
        }
    }

    @Override
    public long getNumPoints() {
        return this.numPoints;
    }

    public ClusterObservations getObservations() {
        return new ClusterObservations(this.s0, this.s1, this.s2);
    }

    @Override
    public void computeParameters() {
        if (this.s0 == 0.0) {
            return;
        }
        this.numPoints = (int)this.s0;
        this.center = this.s1.divide(this.s0);
        if (this.s0 > 1.0) {
            this.radius = this.s2.times(this.s0).minus(this.s1.times(this.s1)).assign((DoubleFunction)new SquareRootFunction()).divide(this.s0);
        }
        this.s0 = 0.0;
        this.s1 = null;
        this.s2 = null;
    }

    public void readFields(DataInput in) throws IOException {
        this.id = in.readInt();
        this.numPoints = in.readLong();
        VectorWritable temp = new VectorWritable();
        temp.readFields(in);
        this.center = temp.get();
        temp.readFields(in);
        this.radius = temp.get();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeLong(this.numPoints);
        VectorWritable.writeVector(out, this.center);
        VectorWritable.writeVector(out, this.radius);
    }

    @Override
    public String asFormatString(String[] bindings) {
        StringBuilder buf = new StringBuilder(50);
        buf.append(this.getIdentifier()).append("{n=").append(this.numPoints);
        if (this.center != null) {
            buf.append(" c=").append(AbstractCluster.formatVector(this.center, bindings));
        }
        if (this.radius != null) {
            buf.append(" r=").append(AbstractCluster.formatVector(this.radius, bindings));
        }
        buf.append('}');
        return buf.toString();
    }

    public abstract String getIdentifier();

    @Override
    public Vector getCenter() {
        return this.center;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Vector getRadius() {
        return this.radius;
    }

    public Vector computeCentroid() {
        return this.s0 == 0.0 ? this.getCenter() : this.s1.divide(this.s0);
    }

    public static String formatVector(Vector v, String[] bindings) {
        StringBuilder buf = new StringBuilder();
        if (v instanceof NamedVector) {
            buf.append(((NamedVector)v).getName()).append(" = ");
        }
        int nzero = 0;
        Iterator iterateNonZero = v.iterateNonZero();
        while (iterateNonZero.hasNext()) {
            iterateNonZero.next();
            ++nzero;
        }
        if (nzero < v.size() || bindings != null) {
            buf.append('[');
            for (int i = 0; i < v.size(); ++i) {
                String label;
                double elem = v.get(i);
                if (elem == 0.0) continue;
                if (bindings != null && (label = bindings[i]) != null) {
                    buf.append(label).append(':');
                } else {
                    buf.append(i).append(':');
                }
                buf.append(String.format(Locale.ENGLISH, "%.3f", elem)).append(", ");
            }
        } else {
            buf.append('[');
            for (int i = 0; i < v.size(); ++i) {
                double elem = v.get(i);
                buf.append(String.format(Locale.ENGLISH, "%.3f", elem)).append(", ");
            }
        }
        if (buf.length() > 1) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    public long count() {
        return this.getNumPoints();
    }
}

