/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sequencelearning.hmm;

import java.util.Map;
import java.util.Random;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;

public class HmmModel
implements Cloneable {
    private int nrOfHiddenStates;
    private int nrOfOutputStates;
    private Matrix transitionMatrix;
    private Matrix emissionMatrix;
    private Vector initialProbabilities;
    private BidiMap hiddenStateNames;
    private BidiMap outputStateNames;

    public HmmModel clone() throws CloneNotSupportedException {
        super.clone();
        HmmModel model = new HmmModel(this.transitionMatrix.clone(), this.emissionMatrix.clone(), this.initialProbabilities.clone());
        if (this.hiddenStateNames != null) {
            model.hiddenStateNames = new TreeBidiMap((Map)this.hiddenStateNames);
        }
        if (this.outputStateNames != null) {
            model.outputStateNames = new TreeBidiMap((Map)this.outputStateNames);
        }
        return model;
    }

    public void assign(HmmModel model) {
        this.nrOfHiddenStates = model.nrOfHiddenStates;
        this.nrOfOutputStates = model.nrOfOutputStates;
        this.hiddenStateNames = model.hiddenStateNames;
        this.outputStateNames = model.outputStateNames;
        this.initialProbabilities = model.initialProbabilities.clone();
        this.emissionMatrix = model.emissionMatrix.clone();
        this.transitionMatrix = model.transitionMatrix.clone();
    }

    public HmmModel(int nrOfHiddenStates, int nrOfOutputStates, long seed) {
        this.nrOfHiddenStates = nrOfHiddenStates;
        this.nrOfOutputStates = nrOfOutputStates;
        this.transitionMatrix = new DenseMatrix(nrOfHiddenStates, nrOfHiddenStates);
        this.emissionMatrix = new DenseMatrix(nrOfHiddenStates, nrOfOutputStates);
        this.initialProbabilities = new DenseVector(nrOfHiddenStates);
        this.initRandomParameters(seed);
    }

    public HmmModel(int nrOfHiddenStates, int nrOfOutputStates) {
        this(nrOfHiddenStates, nrOfOutputStates, 0L);
    }

    public HmmModel(Matrix transitionMatrix, Matrix emissionMatrix, Vector initialProbabilities) {
        this.nrOfHiddenStates = initialProbabilities.size();
        this.nrOfOutputStates = emissionMatrix.numCols();
        this.transitionMatrix = transitionMatrix;
        this.emissionMatrix = emissionMatrix;
        this.initialProbabilities = initialProbabilities;
    }

    private void initRandomParameters(long seed) {
        int j;
        int i;
        Random rand = seed == 0L ? RandomUtils.getRandom() : RandomUtils.getRandom((long)seed);
        double sum = 0.0;
        for (int i2 = 0; i2 < this.nrOfHiddenStates; ++i2) {
            double nextRand = rand.nextDouble();
            this.initialProbabilities.set(i2, nextRand);
            sum += nextRand;
        }
        this.initialProbabilities = this.initialProbabilities.divide(sum);
        double[] values = new double[this.nrOfHiddenStates];
        for (i = 0; i < this.nrOfHiddenStates; ++i) {
            sum = 0.0;
            for (j = 0; j < this.nrOfHiddenStates; ++j) {
                values[j] = rand.nextDouble();
                sum += values[j];
            }
            j = 0;
            while (j < this.nrOfHiddenStates) {
                int n = j++;
                values[n] = values[n] / sum;
            }
            this.transitionMatrix.set(i, values);
        }
        values = new double[this.nrOfOutputStates];
        for (i = 0; i < this.nrOfHiddenStates; ++i) {
            sum = 0.0;
            for (j = 0; j < this.nrOfOutputStates; ++j) {
                values[j] = rand.nextDouble();
                sum += values[j];
            }
            j = 0;
            while (j < this.nrOfOutputStates) {
                int n = j++;
                values[n] = values[n] / sum;
            }
            this.emissionMatrix.set(i, values);
        }
    }

    public int getNrOfHiddenStates() {
        return this.nrOfHiddenStates;
    }

    public int getNrOfOutputStates() {
        return this.nrOfOutputStates;
    }

    public Matrix getTransitionMatrix() {
        return this.transitionMatrix;
    }

    public Matrix getEmissionMatrix() {
        return this.emissionMatrix;
    }

    public Vector getInitialProbabilities() {
        return this.initialProbabilities;
    }

    public Map<String, Integer> getHiddenStateNames() {
        return this.hiddenStateNames;
    }

    public void registerHiddenStateNames(String[] stateNames) {
        if (stateNames != null) {
            this.hiddenStateNames = new TreeBidiMap();
            for (int i = 0; i < stateNames.length; ++i) {
                this.hiddenStateNames.put((Object)stateNames[i], (Object)i);
            }
        }
    }

    public void registerHiddenStateNames(Map<String, Integer> stateNames) {
        if (stateNames != null) {
            this.hiddenStateNames = new TreeBidiMap(stateNames);
        }
    }

    public String getHiddenStateName(int id) {
        if (this.hiddenStateNames == null) {
            return null;
        }
        return (String)this.hiddenStateNames.getKey((Object)id);
    }

    public int getHiddenStateID(String name) {
        if (this.hiddenStateNames == null) {
            return -1;
        }
        Integer tmp = (Integer)this.hiddenStateNames.get((Object)name);
        return tmp == null ? -1 : tmp;
    }

    public Map<String, Integer> getOutputStateNames() {
        return this.outputStateNames;
    }

    public void registerOutputStateNames(String[] stateNames) {
        if (stateNames != null) {
            this.outputStateNames = new TreeBidiMap();
            for (int i = 0; i < stateNames.length; ++i) {
                this.outputStateNames.put((Object)stateNames[i], (Object)i);
            }
        }
    }

    public void registerOutputStateNames(Map<String, Integer> stateNames) {
        if (stateNames != null) {
            this.outputStateNames = new TreeBidiMap(stateNames);
        }
    }

    public String getOutputStateName(int id) {
        if (this.outputStateNames == null) {
            return null;
        }
        return (String)this.outputStateNames.getKey((Object)id);
    }

    public int getOutputStateID(String name) {
        if (this.outputStateNames == null) {
            return -1;
        }
        Integer tmp = (Integer)this.outputStateNames.get((Object)name);
        return tmp == null ? -1 : tmp;
    }
}

