/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sequencelearning.hmm;

import org.apache.mahout.classifier.sequencelearning.hmm.HmmModel;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;

public final class HmmAlgorithms {
    private HmmAlgorithms() {
    }

    public static Matrix forwardAlgorithm(HmmModel model, int[] observations, boolean scaled) {
        DenseMatrix alpha = new DenseMatrix(observations.length, model.getNrOfHiddenStates());
        HmmAlgorithms.forwardAlgorithm((Matrix)alpha, model, observations, scaled);
        return alpha;
    }

    static void forwardAlgorithm(Matrix alpha, HmmModel model, int[] observations, boolean scaled) {
        Vector ip = model.getInitialProbabilities();
        Matrix b = model.getEmissionMatrix();
        Matrix a = model.getTransitionMatrix();
        if (scaled) {
            for (int i = 0; i < model.getNrOfHiddenStates(); ++i) {
                alpha.setQuick(0, i, Math.log(ip.getQuick(i) * b.getQuick(i, observations[0])));
            }
            for (int t = 1; t < observations.length; ++t) {
                for (int i = 0; i < model.getNrOfHiddenStates(); ++i) {
                    double sum = Double.NEGATIVE_INFINITY;
                    for (int j = 0; j < model.getNrOfHiddenStates(); ++j) {
                        double tmp = alpha.getQuick(t - 1, j) + Math.log(a.getQuick(j, i));
                        if (!(tmp > Double.NEGATIVE_INFINITY)) continue;
                        sum = tmp + Math.log(1.0 + Math.exp(sum - tmp));
                    }
                    alpha.setQuick(t, i, sum + Math.log(b.getQuick(i, observations[t])));
                }
            }
        } else {
            for (int i = 0; i < model.getNrOfHiddenStates(); ++i) {
                alpha.setQuick(0, i, ip.getQuick(i) * b.getQuick(i, observations[0]));
            }
            for (int t = 1; t < observations.length; ++t) {
                for (int i = 0; i < model.getNrOfHiddenStates(); ++i) {
                    double sum = 0.0;
                    for (int j = 0; j < model.getNrOfHiddenStates(); ++j) {
                        sum += alpha.getQuick(t - 1, j) * a.getQuick(j, i);
                    }
                    alpha.setQuick(t, i, sum * b.getQuick(i, observations[t]));
                }
            }
        }
    }

    public static Matrix backwardAlgorithm(HmmModel model, int[] observations, boolean scaled) {
        DenseMatrix beta = new DenseMatrix(observations.length, model.getNrOfHiddenStates());
        HmmAlgorithms.backwardAlgorithm((Matrix)beta, model, observations, scaled);
        return beta;
    }

    static void backwardAlgorithm(Matrix beta, HmmModel model, int[] observations, boolean scaled) {
        Matrix b = model.getEmissionMatrix();
        Matrix a = model.getTransitionMatrix();
        if (scaled) {
            for (int i = 0; i < model.getNrOfHiddenStates(); ++i) {
                beta.setQuick(observations.length - 1, i, 0.0);
            }
            for (int t = observations.length - 2; t >= 0; --t) {
                for (int i = 0; i < model.getNrOfHiddenStates(); ++i) {
                    double sum = Double.NEGATIVE_INFINITY;
                    for (int j = 0; j < model.getNrOfHiddenStates(); ++j) {
                        double tmp = beta.getQuick(t + 1, j) + Math.log(a.getQuick(i, j)) + Math.log(b.getQuick(j, observations[t + 1]));
                        if (!(tmp > Double.NEGATIVE_INFINITY)) continue;
                        sum = tmp + Math.log(1.0 + Math.exp(sum - tmp));
                    }
                    beta.setQuick(t, i, sum);
                }
            }
        } else {
            for (int i = 0; i < model.getNrOfHiddenStates(); ++i) {
                beta.setQuick(observations.length - 1, i, 1.0);
            }
            for (int t = observations.length - 2; t >= 0; --t) {
                for (int i = 0; i < model.getNrOfHiddenStates(); ++i) {
                    double sum = 0.0;
                    for (int j = 0; j < model.getNrOfHiddenStates(); ++j) {
                        sum += beta.getQuick(t + 1, j) * a.getQuick(i, j) * b.getQuick(j, observations[t + 1]);
                    }
                    beta.setQuick(t, i, sum);
                }
            }
        }
    }

    public static int[] viterbiAlgorithm(HmmModel model, int[] observations, boolean scaled) {
        double[][] delta = new double[observations.length][model.getNrOfHiddenStates()];
        int[][] phi = new int[observations.length - 1][model.getNrOfHiddenStates()];
        int[] sequence = new int[observations.length];
        HmmAlgorithms.viterbiAlgorithm(sequence, delta, phi, model, observations, scaled);
        return sequence;
    }

    static void viterbiAlgorithm(int[] sequence, double[][] delta, int[][] phi, HmmModel model, int[] observations, boolean scaled) {
        double prob;
        int j;
        double maxProb;
        int maxState;
        int i;
        int t;
        int i2;
        Vector ip = model.getInitialProbabilities();
        Matrix b = model.getEmissionMatrix();
        Matrix a = model.getTransitionMatrix();
        if (scaled) {
            for (i2 = 0; i2 < model.getNrOfHiddenStates(); ++i2) {
                delta[0][i2] = Math.log(ip.getQuick(i2) * b.getQuick(i2, observations[0]));
            }
        } else {
            for (i2 = 0; i2 < model.getNrOfHiddenStates(); ++i2) {
                delta[0][i2] = ip.getQuick(i2) * b.getQuick(i2, observations[0]);
            }
        }
        if (scaled) {
            for (t = 1; t < observations.length; ++t) {
                for (i = 0; i < model.getNrOfHiddenStates(); ++i) {
                    maxState = 0;
                    maxProb = delta[t - 1][0] + Math.log(a.getQuick(0, i));
                    for (j = 1; j < model.getNrOfHiddenStates(); ++j) {
                        prob = delta[t - 1][j] + Math.log(a.getQuick(j, i));
                        if (!(prob > maxProb)) continue;
                        maxProb = prob;
                        maxState = j;
                    }
                    delta[t][i] = maxProb + Math.log(b.getQuick(i, observations[t]));
                    phi[t - 1][i] = maxState;
                }
            }
        } else {
            for (t = 1; t < observations.length; ++t) {
                for (i = 0; i < model.getNrOfHiddenStates(); ++i) {
                    maxState = 0;
                    maxProb = delta[t - 1][0] * a.getQuick(0, i);
                    for (j = 1; j < model.getNrOfHiddenStates(); ++j) {
                        prob = delta[t - 1][j] * a.getQuick(j, i);
                        if (!(prob > maxProb)) continue;
                        maxProb = prob;
                        maxState = j;
                    }
                    delta[t][i] = maxProb * b.getQuick(i, observations[t]);
                    phi[t - 1][i] = maxState;
                }
            }
        }
        double maxProb2 = scaled ? Double.NEGATIVE_INFINITY : 0.0;
        for (int i3 = 0; i3 < model.getNrOfHiddenStates(); ++i3) {
            if (!(delta[observations.length - 1][i3] > maxProb2)) continue;
            maxProb2 = delta[observations.length - 1][i3];
            sequence[observations.length - 1] = i3;
        }
        for (int t2 = observations.length - 2; t2 >= 0; --t2) {
            sequence[t2] = phi[t2][sequence[t2 + 1]];
        }
    }
}

