/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes.trainer;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.map.OpenObjectIntHashMap;

public class NaiveBayesWeightsMapper
extends Mapper<IntWritable, VectorWritable, Text, VectorWritable> {
    private final OpenObjectIntHashMap<String> labelMap = new OpenObjectIntHashMap();
    private Vector featureSum;
    private Vector labelSum;

    protected void map(IntWritable key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
        Vector vector = value.get();
        if (this.featureSum == null) {
            this.featureSum = new RandomAccessSparseVector(vector.size(), vector.getNumNondefaultElements());
            this.labelSum = new RandomAccessSparseVector(this.labelMap.size());
        }
        int label = key.get();
        vector.addTo(this.featureSum);
        this.labelSum.set(label, this.labelSum.get(label) + vector.zSum());
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        URI[] localFiles = DistributedCache.getCacheFiles((Configuration)conf);
        if (localFiles == null || localFiles.length < 1) {
            throw new IllegalArgumentException("missing paths from the DistributedCache");
        }
        Path labelMapFile = new Path(localFiles[0].getPath());
        for (Pair record : new SequenceFileIterable(labelMapFile, true, conf)) {
            this.labelMap.put((Object)((Writable)record.getFirst()).toString(), ((IntWritable)record.getSecond()).get());
        }
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        if (this.featureSum != null) {
            context.write((Object)new Text("__SJ"), (Object)new VectorWritable(this.featureSum));
            context.write((Object)new Text("__SK"), (Object)new VectorWritable(this.labelSum));
        }
        super.cleanup(context);
    }
}

