/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes.trainer;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.classifier.naivebayes.trainer.NaiveBayesInstanceMapper;
import org.apache.mahout.classifier.naivebayes.trainer.NaiveBayesSumReducer;
import org.apache.mahout.classifier.naivebayes.trainer.NaiveBayesThetaComplementaryMapper;
import org.apache.mahout.classifier.naivebayes.trainer.NaiveBayesThetaMapper;
import org.apache.mahout.classifier.naivebayes.trainer.NaiveBayesWeightsMapper;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.math.VectorWritable;

public final class NaiveBayesTrainer {
    public static final String THETA_SUM = "thetaSum";
    public static final String SUM_VECTORS = "sumVectors";
    public static final String CLASS_VECTORS = "classVectors";
    public static final String LABEL_MAP = "labelMap";
    public static final String ALPHA_I = "alphaI";

    private NaiveBayesTrainer() {
    }

    public static void trainNaiveBayes(Path input, Configuration conf, Iterable<String> inputLabels, Path output, int numReducers, float alphaI, boolean trainComplementary) throws IOException, InterruptedException, ClassNotFoundException {
        conf.setFloat(ALPHA_I, alphaI);
        Path labelMapPath = NaiveBayesTrainer.createLabelMapFile(inputLabels, conf, new Path(output, LABEL_MAP));
        Path classVectorPath = new Path(output, CLASS_VECTORS);
        NaiveBayesTrainer.runNaiveBayesByLabelSummer(input, conf, labelMapPath, classVectorPath, numReducers);
        Path weightFilePath = new Path(output, SUM_VECTORS);
        NaiveBayesTrainer.runNaiveBayesWeightSummer(classVectorPath, conf, labelMapPath, weightFilePath, numReducers);
        Path thetaFilePath = new Path(output, THETA_SUM);
        if (trainComplementary) {
            NaiveBayesTrainer.runNaiveBayesThetaComplementarySummer(classVectorPath, conf, weightFilePath, thetaFilePath, numReducers);
        } else {
            NaiveBayesTrainer.runNaiveBayesThetaSummer(classVectorPath, conf, weightFilePath, thetaFilePath, numReducers);
        }
    }

    private static void runNaiveBayesByLabelSummer(Path input, Configuration conf, Path labelMapPath, Path output, int numReducers) throws IOException, InterruptedException, ClassNotFoundException {
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        DistributedCache.setCacheFiles((URI[])new URI[]{labelMapPath.toUri()}, (Configuration)conf);
        Job job = new Job(conf);
        job.setJobName("Train Naive Bayes: input-folder: " + input + ", label-map-file: " + labelMapPath.toString());
        job.setJarByClass(NaiveBayesTrainer.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{input});
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        job.setMapperClass(NaiveBayesInstanceMapper.class);
        job.setCombinerClass(NaiveBayesSumReducer.class);
        job.setReducerClass(NaiveBayesSumReducer.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setNumReduceTasks(numReducers);
        HadoopUtil.delete(conf, output);
        job.waitForCompletion(true);
    }

    private static void runNaiveBayesWeightSummer(Path input, Configuration conf, Path labelMapPath, Path output, int numReducers) throws IOException, InterruptedException, ClassNotFoundException {
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        DistributedCache.setCacheFiles((URI[])new URI[]{labelMapPath.toUri()}, (Configuration)conf);
        Job job = new Job(conf);
        job.setJobName("Train Naive Bayes: input-folder: " + input);
        job.setJarByClass(NaiveBayesTrainer.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{input});
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        job.setMapperClass(NaiveBayesWeightsMapper.class);
        job.setReducerClass(NaiveBayesSumReducer.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setNumReduceTasks(numReducers);
        HadoopUtil.delete(conf, output);
        job.waitForCompletion(true);
    }

    private static void runNaiveBayesThetaSummer(Path input, Configuration conf, Path weightFilePath, Path output, int numReducers) throws IOException, InterruptedException, ClassNotFoundException {
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        DistributedCache.setCacheFiles((URI[])new URI[]{weightFilePath.toUri()}, (Configuration)conf);
        Job job = new Job(conf);
        job.setJobName("Train Naive Bayes: input-folder: " + input + ", label-map-file: " + weightFilePath.toString());
        job.setJarByClass(NaiveBayesTrainer.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{input});
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        job.setMapperClass(NaiveBayesThetaMapper.class);
        job.setReducerClass(NaiveBayesSumReducer.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setNumReduceTasks(numReducers);
        HadoopUtil.delete(conf, output);
        job.waitForCompletion(true);
    }

    private static void runNaiveBayesThetaComplementarySummer(Path input, Configuration conf, Path weightFilePath, Path output, int numReducers) throws IOException, InterruptedException, ClassNotFoundException {
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        DistributedCache.setCacheFiles((URI[])new URI[]{weightFilePath.toUri()}, (Configuration)conf);
        Job job = new Job(conf);
        job.setJobName("Train Naive Bayes: input-folder: " + input + ", label-map-file: " + weightFilePath.toString());
        job.setJarByClass(NaiveBayesTrainer.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{input});
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        job.setMapperClass(NaiveBayesThetaComplementaryMapper.class);
        job.setReducerClass(NaiveBayesSumReducer.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setNumReduceTasks(numReducers);
        HadoopUtil.delete(conf, output);
        job.waitForCompletion(true);
    }

    public static Path createLabelMapFile(Iterable<String> labels, Configuration conf, Path labelMapPathBase) throws IOException {
        FileSystem fs = FileSystem.get((URI)labelMapPathBase.toUri(), (Configuration)conf);
        Path labelMapPath = new Path(labelMapPathBase, LABEL_MAP);
        SequenceFile.Writer dictWriter = new SequenceFile.Writer(fs, conf, labelMapPath, Text.class, IntWritable.class);
        int i = 0;
        for (String label : labels) {
            Text key = new Text(label);
            dictWriter.append((Writable)key, (Writable)new IntWritable(i++));
        }
        dictWriter.close();
        return labelMapPath;
    }
}

