/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes.trainer;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.map.OpenObjectIntHashMap;

public class NaiveBayesInstanceMapper
extends Mapper<Text, VectorWritable, IntWritable, VectorWritable> {
    private final OpenObjectIntHashMap<String> labelMap = new OpenObjectIntHashMap();

    protected void map(Text key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
        if (this.labelMap.containsKey((Object)key.toString())) {
            int label = this.labelMap.get((Object)key.toString());
            context.write((Object)new IntWritable(label), (Object)value);
        } else {
            context.getCounter("NaiveBayes", "Skipped instance: not in label list").increment(1L);
        }
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        URI[] localFiles = DistributedCache.getCacheFiles((Configuration)conf);
        if (localFiles == null || localFiles.length < 1) {
            throw new IllegalArgumentException("missing paths from the DistributedCache");
        }
        Path labelMapFile = new Path(localFiles[0].getPath());
        for (Pair record : new SequenceFileIterable(labelMapFile, true, conf)) {
            this.labelMap.put((Object)((Writable)record.getFirst()).toString(), ((IntWritable)record.getSecond()).get());
        }
    }
}

