/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes;

import org.apache.mahout.classifier.naivebayes.AbstractNaiveBayesClassifier;
import org.apache.mahout.classifier.naivebayes.NaiveBayesModel;

public class StandardNaiveBayesClassifier
extends AbstractNaiveBayesClassifier {
    public StandardNaiveBayesClassifier(NaiveBayesModel model) {
        super(model);
    }

    @Override
    public double getScoreForLabelFeature(int label, int feature) {
        NaiveBayesModel model = this.getModel();
        double result = model.getWeightMatrix().get(label, feature);
        double vocabCount = model.getVocabCount();
        double sumLabelWeight = model.getLabelSum().get(label);
        double numerator = result + (double)model.getAlphaI();
        double denominator = sumLabelWeight + vocabCount;
        double weight = -Math.log(numerator / denominator);
        result = weight / model.getPerlabelThetaNormalizer().get(label);
        return result;
    }
}

