/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class NaiveBayesModel {
    private static final String MODEL = "NaiveBayesModel";
    private Vector labelSum;
    private Vector perlabelThetaNormalizer;
    private Vector featureSum;
    private Matrix weightMatrix;
    private float alphaI;
    private double vocabCount;
    private double totalSum;

    private NaiveBayesModel() {
    }

    public NaiveBayesModel(Matrix matrix, Vector featureSum, Vector labelSum, Vector thetaNormalizer, float alphaI) {
        this.weightMatrix = matrix;
        this.featureSum = featureSum;
        this.labelSum = labelSum;
        this.perlabelThetaNormalizer = thetaNormalizer;
        this.vocabCount = featureSum.getNumNondefaultElements();
        this.totalSum = labelSum.zSum();
        this.alphaI = alphaI;
    }

    private void setLabelSum(Vector labelSum) {
        this.labelSum = labelSum;
    }

    public void setPerlabelThetaNormalizer(Vector perlabelThetaNormalizer) {
        this.perlabelThetaNormalizer = perlabelThetaNormalizer;
    }

    public void setFeatureSum(Vector featureSum) {
        this.featureSum = featureSum;
    }

    public void setWeightMatrix(Matrix weightMatrix) {
        this.weightMatrix = weightMatrix;
    }

    public void setAlphaI(float alphaI) {
        this.alphaI = alphaI;
    }

    public void setVocabCount(double vocabCount) {
        this.vocabCount = vocabCount;
    }

    public void setTotalSum(double totalSum) {
        this.totalSum = totalSum;
    }

    public Vector getLabelSum() {
        return this.labelSum;
    }

    public Vector getPerlabelThetaNormalizer() {
        return this.perlabelThetaNormalizer;
    }

    public Vector getFeatureSum() {
        return this.featureSum;
    }

    public Matrix getWeightMatrix() {
        return this.weightMatrix;
    }

    public float getAlphaI() {
        return this.alphaI;
    }

    public double getVocabCount() {
        return this.vocabCount;
    }

    public double getTotalSum() {
        return this.totalSum;
    }

    public int getNumLabels() {
        return this.labelSum.size();
    }

    public static String getModelName() {
        return MODEL;
    }

    public static NaiveBayesModel fromMRTrainerOutput(Path output, Configuration conf) {
        VectorWritable value;
        Path classVectorPath = new Path(output, "classVectors");
        Path sumVectorPath = new Path(output, "sumVectors");
        Path thetaSumPath = new Path(output, "thetaSum");
        NaiveBayesModel model = new NaiveBayesModel();
        model.setAlphaI(conf.getFloat("alphaI", 1.0f));
        int featureCount = 0;
        int labelCount = 0;
        for (Pair record : new SequenceFileIterable(sumVectorPath, true, conf)) {
            Text key = (Text)record.getFirst();
            VectorWritable value2 = (VectorWritable)((Object)record.getSecond());
            if (key.toString().equals("__SJ")) {
                model.setFeatureSum(value2.get());
                featureCount = value2.get().getNumNondefaultElements();
                model.setVocabCount(featureCount);
                continue;
            }
            if (!key.toString().equals("__SK")) continue;
            model.setLabelSum(value2.get());
            model.setTotalSum(value2.get().zSum());
            labelCount = value2.get().size();
        }
        SparseMatrix matrix = new SparseMatrix(new int[]{labelCount, featureCount});
        for (Pair record : new SequenceFileIterable(classVectorPath, true, conf)) {
            IntWritable label = (IntWritable)record.getFirst();
            value = (VectorWritable)((Object)record.getSecond());
            matrix.assignRow(label.get(), value.get());
        }
        model.setWeightMatrix((Matrix)matrix);
        for (Pair record : new SequenceFileIterable(thetaSumPath, true, conf)) {
            Text key = (Text)record.getFirst();
            value = (VectorWritable)((Object)record.getSecond());
            if (!key.toString().equals("_LTN")) continue;
            model.setPerlabelThetaNormalizer(value.get());
        }
        return model;
    }

    public static void validate(NaiveBayesModel model) {
        if (model == null) {
            return;
        }
        if (model.getAlphaI() <= 0.0f) {
            throw new IllegalArgumentException("Error: AlphaI has to be greater than 0!");
        }
        if (model.getVocabCount() <= 0.0) {
            throw new IllegalArgumentException("Error: The vocab count has to be greater than 0!");
        }
        if (model.getVocabCount() <= 0.0) {
            throw new IllegalArgumentException("Error: The vocab count has to be greater than 0!");
        }
        if (model.getTotalSum() <= 0.0) {
            throw new IllegalArgumentException("Error: The vocab count has to be greater than 0!");
        }
        if (model.getLabelSum() == null || model.getLabelSum().getNumNondefaultElements() <= 0) {
            throw new IllegalArgumentException("Error: The number of labels has to be greater than 0 or defined!");
        }
        if (model.getPerlabelThetaNormalizer() == null || model.getPerlabelThetaNormalizer().getNumNondefaultElements() <= 0) {
            throw new IllegalArgumentException("Error: The number of theta normalizers has to be greater than 0 or defined!");
        }
        if (model.getFeatureSum() == null || model.getFeatureSum().getNumNondefaultElements() <= 0) {
            throw new IllegalArgumentException("Error: The number of features has to be greater than 0 or defined!");
        }
    }
}

