/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes;

import org.apache.mahout.classifier.naivebayes.AbstractNaiveBayesClassifier;
import org.apache.mahout.classifier.naivebayes.NaiveBayesModel;

public class ComplementaryNaiveBayesClassifier
extends AbstractNaiveBayesClassifier {
    public ComplementaryNaiveBayesClassifier(NaiveBayesModel model) {
        super(model);
    }

    @Override
    public double getScoreForLabelFeature(int label, int feature) {
        NaiveBayesModel model = this.getModel();
        double result = model.getWeightMatrix().get(label, feature);
        double vocabCount = model.getVocabCount();
        double featureSum = model.getFeatureSum().get(feature);
        double totalSum = model.getTotalSum();
        double labelSum = model.getLabelSum().get(label);
        double numerator = featureSum - result + (double)model.getAlphaI();
        double denominator = totalSum - labelSum + vocabCount;
        double weight = Math.log(numerator / denominator);
        result = weight / model.getPerlabelThetaNormalizer().get(label);
        return result;
    }
}

