/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes;

import java.util.Iterator;
import org.apache.mahout.classifier.AbstractVectorClassifier;
import org.apache.mahout.classifier.naivebayes.NaiveBayesModel;
import org.apache.mahout.math.Vector;

public abstract class AbstractNaiveBayesClassifier
extends AbstractVectorClassifier {
    private final NaiveBayesModel model;

    protected AbstractNaiveBayesClassifier(NaiveBayesModel model) {
        this.model = model;
    }

    protected NaiveBayesModel getModel() {
        return this.model;
    }

    public abstract double getScoreForLabelFeature(int var1, int var2);

    public double getScoreForLabelInstance(int label, Vector instance) {
        double result = 0.0;
        Iterator it = instance.iterateNonZero();
        while (it.hasNext()) {
            Vector.Element e = (Vector.Element)it.next();
            result += this.getScoreForLabelFeature(label, e.index());
        }
        return result;
    }

    @Override
    public int numCategories() {
        return this.model.getNumLabels();
    }

    @Override
    public Vector classify(Vector instance) {
        Vector score = this.model.getLabelSum().like();
        for (int i = 0; i < score.size(); ++i) {
            score.set(i, this.getScoreForLabelInstance(i, instance));
        }
        return score;
    }

    @Override
    public double classifyScalar(Vector instance) {
        throw new UnsupportedOperationException("Not supported in Naive Bayes");
    }
}

