/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.evaluation;

import com.google.common.base.Preconditions;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.list.DoubleArrayList;

public class Auc {
    private int maxBufferSize = 10000;
    private final DoubleArrayList[] scores = new DoubleArrayList[]{new DoubleArrayList(), new DoubleArrayList()};
    private final Random rand;
    private int samples;
    private final double threshold;
    private final Matrix confusion = new DenseMatrix(2, 2);
    private final DenseMatrix entropy = new DenseMatrix(2, 2);
    private boolean probabilityScore = true;
    private boolean hasScore;

    public Auc(double threshold) {
        this.rand = RandomUtils.getRandom();
        this.threshold = threshold;
    }

    public Auc() {
        this(0.5);
    }

    public void add(int trueValue, double score) {
        DoubleArrayList buf;
        Preconditions.checkArgument((trueValue == 0 || trueValue == 1 ? 1 : 0) != 0, (Object)"True value must be 0 or 1");
        this.hasScore = true;
        int predictedClass = score > this.threshold ? 1 : 0;
        this.confusion.set(trueValue, predictedClass, this.confusion.get(trueValue, predictedClass) + 1.0);
        ++this.samples;
        if (this.isProbabilityScore()) {
            double limited = Math.max(1.0E-20, Math.min(score, 1.0));
            double v0 = this.entropy.get(trueValue, 0);
            this.entropy.set(trueValue, 0, (Math.log(1.0 - limited) - v0) / (double)this.samples + v0);
            double v1 = this.entropy.get(trueValue, 1);
            this.entropy.set(trueValue, 1, (Math.log(limited) - v1) / (double)this.samples + v1);
        }
        if ((buf = this.scores[trueValue]).size() >= this.maxBufferSize) {
            int index = this.rand.nextInt(this.samples);
            if (index < buf.size()) {
                buf.set(index, score);
            }
        } else {
            buf.add(score);
        }
    }

    public void add(int trueValue, int predictedClass) {
        this.hasScore = false;
        Preconditions.checkArgument((trueValue == 0 || trueValue == 1 ? 1 : 0) != 0, (Object)"True value must be 0 or 1");
        this.confusion.set(trueValue, predictedClass, this.confusion.get(trueValue, predictedClass) + 1.0);
    }

    public double auc() {
        Preconditions.checkArgument((boolean)this.hasScore, (Object)"Can't compute AUC for classifier without a score");
        this.scores[0].sort();
        this.scores[1].sort();
        double n0 = this.scores[0].size();
        double n1 = this.scores[1].size();
        if (n0 == 0.0 || n1 == 0.0) {
            return 0.5;
        }
        int i0 = 0;
        int i1 = 0;
        int rank = 1;
        double rankSum = 0.0;
        while ((double)i0 < n0 && (double)i1 < n1) {
            double v1;
            double v0 = this.scores[0].get(i0);
            if (v0 < (v1 = this.scores[1].get(i1))) {
                ++i0;
                ++rank;
                continue;
            }
            if (v1 < v0) {
                ++i1;
                rankSum += (double)rank;
                ++rank;
                continue;
            }
            double tieScore = v0;
            int k0 = 0;
            while ((double)i0 < n0 && this.scores[0].get(i0) == tieScore) {
                ++k0;
                ++i0;
            }
            int k1 = 0;
            while ((double)i1 < n1 && this.scores[1].get(i1) == tieScore) {
                ++k1;
                ++i1;
            }
            rankSum += ((double)rank + (double)(k0 + k1 - 1) / 2.0) * (double)k1;
            rank += k0 + k1;
        }
        if ((double)i1 < n1) {
            rankSum += ((double)rank + (n1 - (double)i1 - 1.0) / 2.0) * (n1 - (double)i1);
            rank = (int)((double)rank + (n1 - (double)i1));
        }
        return (rankSum / n1 - (n1 + 1.0) / 2.0) / n0;
    }

    public Matrix confusion() {
        return this.confusion;
    }

    public Matrix entropy() {
        if (!this.hasScore) {
            double p = (0.5 + this.confusion.get(1, 1)) / (1.0 + this.confusion.get(0, 0) + this.confusion.get(1, 1));
            this.entropy.set(0, 0, this.confusion.get(0, 0) * Math.log(1.0 - p));
            this.entropy.set(0, 1, this.confusion.get(0, 1) * Math.log(p));
            this.entropy.set(1, 0, this.confusion.get(1, 0) * Math.log(1.0 - p));
            this.entropy.set(1, 1, this.confusion.get(1, 1) * Math.log(p));
        }
        return this.entropy;
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public boolean isProbabilityScore() {
        return this.probabilityScore;
    }

    public void setProbabilityScore(boolean probabilityScore) {
        this.probabilityScore = probabilityScore;
    }
}

