/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.discriminative;

import java.util.Iterator;
import org.apache.mahout.classifier.discriminative.LinearModel;
import org.apache.mahout.classifier.discriminative.LinearTrainer;
import org.apache.mahout.math.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinnowTrainer
extends LinearTrainer {
    private static final Logger log = LoggerFactory.getLogger(WinnowTrainer.class);
    private final double promotionStep;

    public WinnowTrainer(int dimension, double promotionStep, double threshold, double init, double initBias) {
        super(dimension, threshold, init, initBias);
        this.promotionStep = promotionStep;
    }

    public WinnowTrainer(int dimension, double promotionStep) {
        this(dimension, promotionStep, 0.5, 1.0, 0.0);
    }

    public WinnowTrainer(int dimension) {
        this(dimension, 2.0);
    }

    @Override
    protected void update(double label, Vector dataPoint, LinearModel model) {
        if (label > 0.0) {
            Vector updateVector = dataPoint.times(1.0 / this.promotionStep);
            log.info("Winnow update positive: {}", (Object)updateVector);
            Iterator iter = updateVector.iterateNonZero();
            while (iter.hasNext()) {
                Vector.Element element = (Vector.Element)iter.next();
                model.timesDelta(element.index(), element.get());
            }
        } else {
            Vector updateVector = dataPoint.times(1.0 / this.promotionStep);
            log.info("Winnow update negative: {}", (Object)updateVector);
            Iterator iter = updateVector.iterateNonZero();
            while (iter.hasNext()) {
                Vector.Element element = (Vector.Element)iter.next();
                model.timesDelta(element.index(), element.get());
            }
        }
        log.info(model.toString());
    }
}

