/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.discriminative;

import org.apache.mahout.classifier.discriminative.LinearModel;
import org.apache.mahout.classifier.discriminative.LinearTrainer;
import org.apache.mahout.math.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerceptronTrainer
extends LinearTrainer {
    private static final Logger log = LoggerFactory.getLogger(PerceptronTrainer.class);
    private final double learningRate;

    public PerceptronTrainer(int dimension, double threshold, double learningRate, double init, double initBias) {
        super(dimension, threshold, init, initBias);
        this.learningRate = learningRate;
    }

    @Override
    protected void update(double label, Vector dataPoint, LinearModel model) {
        double factor = 1.0;
        if (label == 0.0) {
            factor = -1.0;
        }
        Vector updateVector = dataPoint.times(factor).times(this.learningRate);
        log.debug("Updatevec: {}", (Object)updateVector);
        model.addDelta(updateVector);
        model.shiftBias(factor * this.learningRate);
        log.debug("{}", (Object)model);
    }
}

