/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.discriminative;

import org.apache.mahout.math.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinearModel {
    private static final Logger log = LoggerFactory.getLogger(LinearModel.class);
    private Vector hyperplane;
    private double bias;
    private final double threshold;

    public LinearModel(Vector hyperplane, double displacement, double threshold) {
        this.hyperplane = hyperplane;
        this.bias = displacement;
        this.threshold = threshold;
    }

    public LinearModel(Vector hyperplane) {
        this(hyperplane, 0.0, 0.5);
    }

    public boolean classify(Vector dataPoint) {
        double product = this.hyperplane.dot(dataPoint);
        if (log.isDebugEnabled()) {
            log.debug("model: {} product: {} Bias: {} threshold: {}", new Object[]{this, product, this.bias, this.threshold});
        }
        return product + this.bias > this.threshold;
    }

    public void addDelta(Vector delta) {
        this.hyperplane = this.hyperplane.plus(delta);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Model: ");
        for (int i = 0; i < this.hyperplane.size(); ++i) {
            builder.append("  ").append(this.hyperplane.get(i));
        }
        builder.append(" C: ").append(this.bias);
        return builder.toString();
    }

    public void shiftBias(double factor) {
        this.bias += factor;
    }

    public void timesDelta(int index, double delta) {
        double element = this.hyperplane.get(index);
        this.hyperplane.setQuick(index, element *= delta);
    }
}

