/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes.model;

import java.util.Collection;
import org.apache.mahout.classifier.ClassifierResult;
import org.apache.mahout.classifier.bayes.exceptions.InvalidDatastoreException;
import org.apache.mahout.classifier.bayes.interfaces.Algorithm;
import org.apache.mahout.classifier.bayes.interfaces.Datastore;

public class ClassifierContext {
    private final Algorithm algorithm;
    private final Datastore datastore;

    public ClassifierContext(Algorithm algorithm, Datastore datastore) {
        this.algorithm = algorithm;
        this.datastore = datastore;
    }

    public void initialize() throws InvalidDatastoreException {
        this.datastore.initialize();
        this.algorithm.initialize(this.datastore);
    }

    public ClassifierResult classifyDocument(String[] document, String defaultCategory) throws InvalidDatastoreException {
        return this.algorithm.classifyDocument(document, this.datastore, defaultCategory);
    }

    public ClassifierResult[] classifyDocument(String[] document, String defaultCategory, int numResults) throws InvalidDatastoreException {
        return this.algorithm.classifyDocument(document, this.datastore, defaultCategory, numResults);
    }

    public Collection<String> getLabels() throws InvalidDatastoreException {
        return this.algorithm.getLabels(this.datastore);
    }
}

