/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes.mapreduce.common;

import java.io.IOException;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.classifier.bayes.common.BayesParameters;
import org.apache.mahout.classifier.bayes.mapreduce.bayes.BayesDriver;
import org.apache.mahout.classifier.bayes.mapreduce.common.BayesJob;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobExecutor {
    private static final Logger log = LoggerFactory.getLogger(BayesDriver.class);

    private JobExecutor() {
    }

    public static void execute(String[] args, BayesJob job) throws IOException {
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption inputOpt = DefaultOptionCreator.inputOption().create();
        DefaultOption outputOpt = DefaultOptionCreator.outputOption().create();
        Option helpOpt = DefaultOptionCreator.helpOption();
        Group group = gbuilder.withName("Options").withOption((Option)inputOpt).withOption((Option)outputOpt).withOption(helpOpt).create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption(helpOpt)) {
                CommandLineUtil.printHelp(group);
                return;
            }
            Path input = new Path(cmdLine.getValue((Option)inputOpt).toString());
            Path output = new Path(cmdLine.getValue((Option)outputOpt).toString());
            BayesParameters bayesParams = new BayesParameters();
            bayesParams.setGramSize(1);
            job.runJob(input, output, bayesParams);
        }
        catch (OptionException e) {
            log.error(e.getMessage());
            CommandLineUtil.printHelp(group);
        }
    }
}

