/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes.mapreduce.common;

import com.google.common.base.Preconditions;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.mahout.common.StringTuple;

public class FeaturePartitioner
implements Partitioner<StringTuple, DoubleWritable> {
    public int getPartition(StringTuple key, DoubleWritable value, int numPartitions) {
        Preconditions.checkArgument((key.length() >= 2 && key.length() <= 3 ? 1 : 0) != 0, (Object)"StringTuple length out of bounds");
        String feature = key.length() == 2 ? key.stringAt(1) : key.stringAt(2);
        int length = feature.length();
        int right = 0;
        if (length > 0) {
            right = (3 + length) % length;
        }
        int hash = WritableComparator.hashBytes((byte[])feature.getBytes(), (int)right);
        return (hash & Integer.MAX_VALUE) % numPartitions;
    }

    public void configure(JobConf job) {
    }
}

