/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes.mapreduce.common;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.mahout.classifier.bayes.common.BayesParameters;
import org.apache.mahout.classifier.bayes.mapreduce.common.BayesJob;
import org.apache.mahout.classifier.bayes.mapreduce.common.BayesWeightSummerMapper;
import org.apache.mahout.classifier.bayes.mapreduce.common.BayesWeightSummerOutputFormat;
import org.apache.mahout.classifier.bayes.mapreduce.common.BayesWeightSummerReducer;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.StringTuple;

public class BayesWeightSummerDriver
implements BayesJob {
    @Override
    public void runJob(Path input, Path output, BayesParameters params) throws IOException {
        JobClient client = new JobClient();
        JobConf conf = new JobConf(BayesWeightSummerDriver.class);
        conf.setJobName("Bayes Weight Summer Driver running over input: " + input);
        conf.setOutputKeyClass(StringTuple.class);
        conf.setOutputValueClass(DoubleWritable.class);
        FileInputFormat.addInputPath((JobConf)conf, (Path)new Path(output, "trainer-tfIdf/trainer-tfIdf"));
        Path outPath = new Path(output, "trainer-weights");
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outPath);
        HadoopUtil.delete((Configuration)conf, outPath);
        conf.setMapperClass(BayesWeightSummerMapper.class);
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setCombinerClass(BayesWeightSummerReducer.class);
        conf.setReducerClass(BayesWeightSummerReducer.class);
        conf.setOutputFormat(BayesWeightSummerOutputFormat.class);
        conf.set("bayes.parameters", params.toString());
        conf.set("output.table", output.toString());
        client.setConf((Configuration)conf);
        JobClient.runJob((JobConf)conf);
    }
}

