/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes.mapreduce.common;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.mahout.common.StringTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BayesTfIdfReducer
extends MapReduceBase
implements Reducer<StringTuple, DoubleWritable, StringTuple, DoubleWritable> {
    private static final Logger log = LoggerFactory.getLogger(BayesTfIdfReducer.class);

    public void reduce(StringTuple key, Iterator<DoubleWritable> values, OutputCollector<StringTuple, DoubleWritable> output, Reporter reporter) throws IOException {
        if (key.stringAt(0).equals("__FS")) {
            double vocabCount = 0.0;
            while (values.hasNext()) {
                reporter.setStatus("Bayes TfIdf Reducer: vocabCount " + vocabCount);
                vocabCount += values.next().get();
            }
            log.info("{}\t{}", (Object)key, (Object)vocabCount);
            output.collect((Object)key, (Object)new DoubleWritable(vocabCount));
        } else if (key.stringAt(0).equals("__WT")) {
            double idfTimesDIJ = 1.0;
            while (values.hasNext()) {
                idfTimesDIJ *= values.next().get();
            }
            reporter.setStatus("Bayes TfIdf Reducer: " + key + " => " + idfTimesDIJ);
            output.collect((Object)key, (Object)new DoubleWritable(idfTimesDIJ));
        } else {
            throw new IllegalArgumentException("Unexpected StringTuple: " + key);
        }
    }
}

