/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes.mapreduce.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.GenericsUtil;
import org.apache.mahout.common.StringTuple;
import org.apache.mahout.math.map.OpenObjectDoubleHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BayesTfIdfMapper
extends MapReduceBase
implements Mapper<StringTuple, DoubleWritable, StringTuple, DoubleWritable> {
    private static final Logger log = LoggerFactory.getLogger(BayesTfIdfMapper.class);
    private static final StringTuple VOCAB_COUNT = new StringTuple("__FS");
    private static final DoubleWritable ONE = new DoubleWritable(1.0);
    private final OpenObjectDoubleHashMap<String> labelDocumentCounts = new OpenObjectDoubleHashMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void map(StringTuple key, DoubleWritable value, OutputCollector<StringTuple, DoubleWritable> output, Reporter reporter) throws IOException {
        if (key.length() == 3) {
            if (key.stringAt(0).equals("__WT")) {
                reporter.setStatus("Bayes TfIdf Mapper: Tf: " + key);
                output.collect((Object)key, (Object)value);
                return;
            } else {
                if (!key.stringAt(0).equals("__DF")) throw new IllegalArgumentException("Unrecognized Tuple: " + key);
                String label = key.stringAt(1);
                Double labelDocumentCount = this.labelDocumentCounts.get((Object)label);
                double logIdf = Math.log(labelDocumentCount / value.get());
                key.replaceAt(0, "__WT");
                output.collect((Object)key, (Object)new DoubleWritable(logIdf));
                reporter.setStatus("Bayes TfIdf Mapper: log(Idf): " + key);
            }
            return;
        } else {
            if (key.length() != 2) return;
            if (!key.stringAt(0).equals("__FC")) throw new IllegalArgumentException("Unexpected Tuple: " + key);
            output.collect((Object)VOCAB_COUNT, (Object)ONE);
            reporter.setStatus("Bayes TfIdf Mapper: vocabCount");
        }
    }

    public void configure(JobConf job) {
        try {
            this.labelDocumentCounts.clear();
            Map labelDocCountTemp = new HashMap();
            DefaultStringifier mapStringifier = new DefaultStringifier((Configuration)job, GenericsUtil.getClass(labelDocCountTemp));
            String labelDocumentCountString = job.get("cnaivebayes.labelDocumentCounts", mapStringifier.toString(labelDocCountTemp));
            labelDocCountTemp = (Map)mapStringifier.fromString(labelDocumentCountString);
            for (Map.Entry stringDoubleEntry : labelDocCountTemp.entrySet()) {
                this.labelDocumentCounts.put(stringDoubleEntry.getKey(), ((Double)stringDoubleEntry.getValue()).doubleValue());
            }
        }
        catch (IOException ex) {
            log.warn(ex.toString(), (Throwable)ex);
        }
    }
}

