/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes.mapreduce.common;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.mahout.classifier.bayes.common.BayesParameters;
import org.apache.mahout.common.StringTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BayesFeatureReducer
extends MapReduceBase
implements Reducer<StringTuple, DoubleWritable, StringTuple, DoubleWritable> {
    private static final Logger log = LoggerFactory.getLogger(BayesFeatureReducer.class);
    private double minSupport = -1.0;
    private double minDf = -1.0;
    private String currentDfFeature;
    private double currentCorpusDf;
    private double currentCorpusTf;

    public void reduce(StringTuple key, Iterator<DoubleWritable> values, OutputCollector<StringTuple, DoubleWritable> output, Reporter reporter) throws IOException {
        int featureIndex;
        double sum = 0.0;
        while (values.hasNext()) {
            reporter.setStatus("Feature Reducer:" + key);
            sum += values.next().get();
        }
        reporter.setStatus("Bayes Feature Reducer: " + key + " => " + sum);
        Preconditions.checkArgument((key.length() >= 2 && key.length() <= 3 ? 1 : 0) != 0, (Object)"StringTuple length out of bounds, not (2 < length < 3)");
        int n = featureIndex = key.length() == 2 ? 1 : 2;
        if (key.stringAt(0).equals("__LC")) {
            output.collect((Object)key, (Object)new DoubleWritable(sum));
        } else if (key.stringAt(0).equals("__FF")) {
            this.currentDfFeature = key.stringAt(1);
            this.currentCorpusTf = sum;
            this.currentCorpusDf = -1.0;
            if (this.minSupport > 0.0 && this.currentCorpusTf < this.minSupport) {
                reporter.incrCounter("skipped", "less_than_minSupport", 1L);
            }
        } else {
            if (!key.stringAt(featureIndex).equals(this.currentDfFeature)) {
                throw new IllegalStateException("Found feature data " + key + " prior to feature tf");
            }
            if (this.minSupport > 0.0 && this.currentCorpusTf < this.minSupport) {
                reporter.incrCounter("skipped", "less_than_minSupport_label-term", 1L);
            } else if (key.stringAt(0).equals("__FC")) {
                this.currentCorpusDf = sum;
                if (this.minDf > 0.0 && this.currentCorpusDf < this.minDf) {
                    reporter.incrCounter("skipped", "less_than_minDf", 1L);
                } else {
                    output.collect((Object)key, (Object)new DoubleWritable(sum));
                }
            } else {
                if (this.currentCorpusDf == -1.0) {
                    throw new IllegalStateException("Found feature data " + key + " prior to feature count");
                }
                if (this.minDf > 0.0 && this.currentCorpusDf < this.minDf) {
                    reporter.incrCounter("skipped", "less_than_minDf_label-term", 1L);
                } else {
                    output.collect((Object)key, (Object)new DoubleWritable(sum));
                }
            }
        }
    }

    public void configure(JobConf job) {
        try {
            BayesParameters params = new BayesParameters(job.get("bayes.parameters", ""));
            log.info("Bayes Parameter {}", (Object)params.print());
            this.minSupport = params.getMinSupport();
            this.minDf = params.getMinDF();
        }
        catch (IOException ex) {
            log.warn(ex.toString(), (Throwable)ex);
        }
    }
}

