/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes.mapreduce.common;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.KeyValueTextInputFormat;
import org.apache.mahout.classifier.bayes.common.BayesParameters;
import org.apache.mahout.classifier.bayes.mapreduce.common.BayesFeatureCombiner;
import org.apache.mahout.classifier.bayes.mapreduce.common.BayesFeatureMapper;
import org.apache.mahout.classifier.bayes.mapreduce.common.BayesFeatureOutputFormat;
import org.apache.mahout.classifier.bayes.mapreduce.common.BayesFeatureReducer;
import org.apache.mahout.classifier.bayes.mapreduce.common.BayesJob;
import org.apache.mahout.classifier.bayes.mapreduce.common.FeatureLabelComparator;
import org.apache.mahout.classifier.bayes.mapreduce.common.FeaturePartitioner;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.StringTuple;

public class BayesFeatureDriver
implements BayesJob {
    @Override
    public void runJob(Path input, Path output, BayesParameters params) throws IOException {
        JobClient client = new JobClient();
        JobConf conf = new JobConf(BayesFeatureDriver.class);
        conf.setJobName("Bayes Feature Driver running over input: " + input);
        conf.setOutputKeyClass(StringTuple.class);
        conf.setOutputValueClass(DoubleWritable.class);
        conf.setPartitionerClass(FeaturePartitioner.class);
        conf.setOutputKeyComparatorClass(FeatureLabelComparator.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{input});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)output);
        conf.setMapperClass(BayesFeatureMapper.class);
        conf.setInputFormat(KeyValueTextInputFormat.class);
        conf.setCombinerClass(BayesFeatureCombiner.class);
        conf.setReducerClass(BayesFeatureReducer.class);
        conf.setOutputFormat(BayesFeatureOutputFormat.class);
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        HadoopUtil.delete((Configuration)conf, output);
        conf.set("bayes.parameters", params.toString());
        client.setConf((Configuration)conf);
        JobClient.runJob((JobConf)conf);
    }

    public static void main(String[] args) throws IOException {
        BayesFeatureDriver driver = new BayesFeatureDriver();
        BayesParameters p = new BayesParameters();
        p.setGramSize(1);
        Path input = new Path("/home/drew/mahout/bayes/20news-input");
        Path output = new Path("/home/drew/mahout/bayes/20-news-features");
        driver.runJob(input, output, p);
    }
}

