/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes.mapreduce.cbayes;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.GenericsUtil;
import org.apache.mahout.common.Parameters;
import org.apache.mahout.common.StringTuple;
import org.apache.mahout.math.function.ObjectDoubleProcedure;
import org.apache.mahout.math.map.OpenObjectDoubleHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CBayesThetaNormalizerMapper
extends MapReduceBase
implements Mapper<StringTuple, DoubleWritable, StringTuple, DoubleWritable> {
    private static final Logger log = LoggerFactory.getLogger(CBayesThetaNormalizerMapper.class);
    private final OpenObjectDoubleHashMap<String> labelWeightSum = new OpenObjectDoubleHashMap();
    private double sigmaJSigmaK;
    private double vocabCount;
    private double alphaI = 1.0;

    public void map(StringTuple key, final DoubleWritable value, final OutputCollector<StringTuple, DoubleWritable> output, final Reporter reporter) throws IOException {
        if (key.stringAt(0).equals("__SJ")) {
            this.labelWeightSum.forEachPair((ObjectDoubleProcedure)new ObjectDoubleProcedure<String>(){

                public boolean apply(String label, double sigmaJ) {
                    double weight = Math.log((value.get() + CBayesThetaNormalizerMapper.this.alphaI) / (CBayesThetaNormalizerMapper.this.sigmaJSigmaK - sigmaJ + CBayesThetaNormalizerMapper.this.vocabCount));
                    reporter.setStatus("Complementary Bayes Theta Normalizer Mapper: " + label + " => " + weight);
                    StringTuple normalizerTuple = new StringTuple("_LTN");
                    normalizerTuple.add(label);
                    try {
                        output.collect((Object)normalizerTuple, (Object)new DoubleWritable(weight));
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                    return true;
                }
            });
        } else {
            String label = key.stringAt(1);
            double dIJ = value.get();
            double denominator = 0.5 * (this.sigmaJSigmaK / this.vocabCount + dIJ * (double)this.labelWeightSum.size());
            double weight = Math.log(1.0 - dIJ / denominator);
            reporter.setStatus("Complementary Bayes Theta Normalizer Mapper: " + label + " => " + weight);
            StringTuple normalizerTuple = new StringTuple("_LTN");
            normalizerTuple.add(label);
            output.collect((Object)normalizerTuple, (Object)new DoubleWritable(weight));
        }
    }

    public void configure(JobConf job) {
        try {
            this.labelWeightSum.clear();
            Map labelWeightSumTemp = new HashMap();
            DefaultStringifier mapStringifier = new DefaultStringifier((Configuration)job, GenericsUtil.getClass(labelWeightSumTemp));
            String labelWeightSumString = job.get("cnaivebayes.sigma_k", mapStringifier.toString(labelWeightSumTemp));
            labelWeightSumTemp = (Map)mapStringifier.fromString(labelWeightSumString);
            for (Map.Entry stringDoubleEntry : labelWeightSumTemp.entrySet()) {
                this.labelWeightSum.put(stringDoubleEntry.getKey(), ((Double)stringDoubleEntry.getValue()).doubleValue());
            }
            DefaultStringifier stringifier = new DefaultStringifier((Configuration)job, GenericsUtil.getClass((Object)this.sigmaJSigmaK));
            String sigmaJSigmaKString = job.get("cnaivebayes.sigma_jSigma_k", stringifier.toString((Object)this.sigmaJSigmaK));
            this.sigmaJSigmaK = (Double)stringifier.fromString(sigmaJSigmaKString);
            String vocabCountString = job.get("cnaivebayes.vocabCount", stringifier.toString((Object)this.vocabCount));
            this.vocabCount = (Double)stringifier.fromString(vocabCountString);
            Parameters params = new Parameters(job.get("bayes.parameters", ""));
            this.alphaI = Double.valueOf(params.get("alpha_i", "1.0"));
        }
        catch (IOException ex) {
            log.warn(ex.toString(), (Throwable)ex);
        }
    }
}

