/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes.mapreduce.cbayes;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.classifier.bayes.common.BayesParameters;
import org.apache.mahout.classifier.bayes.mapreduce.cbayes.CBayesThetaNormalizerDriver;
import org.apache.mahout.classifier.bayes.mapreduce.common.BayesFeatureDriver;
import org.apache.mahout.classifier.bayes.mapreduce.common.BayesJob;
import org.apache.mahout.classifier.bayes.mapreduce.common.BayesTfIdfDriver;
import org.apache.mahout.classifier.bayes.mapreduce.common.BayesWeightSummerDriver;
import org.apache.mahout.common.HadoopUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CBayesDriver
implements BayesJob {
    private static final Logger log = LoggerFactory.getLogger(CBayesDriver.class);

    @Override
    public void runJob(Path input, Path output, BayesParameters params) throws IOException {
        Configuration conf = new Configuration();
        HadoopUtil.delete(conf, output);
        log.info("Reading features...");
        BayesFeatureDriver feature = new BayesFeatureDriver();
        feature.runJob(input, output, params);
        log.info("Calculating Tf-Idf...");
        BayesTfIdfDriver tfidf = new BayesTfIdfDriver();
        tfidf.runJob(input, output, params);
        log.info("Calculating weight sums for labels and features...");
        BayesWeightSummerDriver summer = new BayesWeightSummerDriver();
        summer.runJob(input, output, params);
        log.info("Calculating the weight Normalisation factor for each complement class...");
        CBayesThetaNormalizerDriver normalizer = new CBayesThetaNormalizerDriver();
        normalizer.runJob(input, output, params);
        if (params.isSkipCleanup()) {
            return;
        }
        Path docCountOutPath = new Path(output, "trainer-docCount");
        HadoopUtil.delete(conf, docCountOutPath);
        Path termDocCountOutPath = new Path(output, "trainer-termDocCount");
        HadoopUtil.delete(conf, termDocCountOutPath);
        Path featureCountOutPath = new Path(output, "trainer-featureCount");
        HadoopUtil.delete(conf, featureCountOutPath);
        Path wordFreqOutPath = new Path(output, "trainer-wordFreq");
        HadoopUtil.delete(conf, wordFreqOutPath);
        Path vocabCountPath = new Path(output, "trainer-tfIdf/trainer-vocabCount");
        HadoopUtil.delete(conf, vocabCountPath);
        Path vocabCountOutPath = new Path(output, "trainer-vocabCount");
        HadoopUtil.delete(conf, vocabCountOutPath);
    }
}

