/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes.mapreduce.bayes;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.GenericsUtil;
import org.apache.mahout.classifier.bayes.common.BayesParameters;
import org.apache.mahout.classifier.bayes.io.SequenceFileModelReader;
import org.apache.mahout.classifier.bayes.mapreduce.bayes.BayesThetaNormalizerMapper;
import org.apache.mahout.classifier.bayes.mapreduce.bayes.BayesThetaNormalizerReducer;
import org.apache.mahout.classifier.bayes.mapreduce.common.BayesJob;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.StringTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BayesThetaNormalizerDriver
implements BayesJob {
    private static final Logger log = LoggerFactory.getLogger(BayesThetaNormalizerDriver.class);

    @Override
    public void runJob(Path input, Path output, BayesParameters params) throws IOException {
        JobClient client = new JobClient();
        JobConf conf = new JobConf(BayesThetaNormalizerDriver.class);
        conf.setJobName("Bayes Theta Normalizer Driver running over input: " + input);
        conf.setOutputKeyClass(StringTuple.class);
        conf.setOutputValueClass(DoubleWritable.class);
        FileInputFormat.addInputPath((JobConf)conf, (Path)new Path(output, "trainer-tfIdf/trainer-tfIdf"));
        Path outPath = new Path(output, "trainer-thetaNormalizer");
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outPath);
        conf.setMapperClass(BayesThetaNormalizerMapper.class);
        conf.setInputFormat(SequenceFileInputFormat.class);
        conf.setCombinerClass(BayesThetaNormalizerReducer.class);
        conf.setReducerClass(BayesThetaNormalizerReducer.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        HadoopUtil.delete((Configuration)conf, outPath);
        Path sigmaKFiles = new Path(output, "trainer-weights/Sigma_k/*");
        Map<String, Double> labelWeightSum = SequenceFileModelReader.readLabelSums(sigmaKFiles, (Configuration)conf);
        DefaultStringifier mapStringifier = new DefaultStringifier((Configuration)conf, GenericsUtil.getClass(labelWeightSum));
        String labelWeightSumString = mapStringifier.toString(labelWeightSum);
        log.info("Sigma_k for Each Label");
        Map c = (Map)mapStringifier.fromString(labelWeightSumString);
        log.info("{}", (Object)c);
        conf.set("cnaivebayes.sigma_k", labelWeightSumString);
        Path sigmaJSigmaKFile = new Path(output, "trainer-weights/Sigma_kSigma_j/*");
        double sigmaJSigmaK = SequenceFileModelReader.readSigmaJSigmaK(sigmaJSigmaKFile, (Configuration)conf);
        DefaultStringifier stringifier = new DefaultStringifier((Configuration)conf, Double.class);
        String sigmaJSigmaKString = stringifier.toString((Object)sigmaJSigmaK);
        log.info("Sigma_kSigma_j for each Label and for each Features");
        double retSigmaJSigmaK = (Double)stringifier.fromString(sigmaJSigmaKString);
        log.info("{}", (Object)retSigmaJSigmaK);
        conf.set("cnaivebayes.sigma_jSigma_k", sigmaJSigmaKString);
        Path vocabCountFile = new Path(output, "trainer-tfIdf/trainer-vocabCount/*");
        double vocabCount = SequenceFileModelReader.readVocabCount(vocabCountFile, (Configuration)conf);
        String vocabCountString = stringifier.toString((Object)vocabCount);
        log.info("Vocabulary Count");
        conf.set("cnaivebayes.vocabCount", vocabCountString);
        double retvocabCount = (Double)stringifier.fromString(vocabCountString);
        log.info("{}", (Object)retvocabCount);
        conf.set("bayes.parameters", params.toString());
        conf.set("output.table", output.toString());
        client.setConf((Configuration)conf);
        JobClient.runJob((JobConf)conf);
    }
}

