/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes.mapreduce.bayes;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.mahout.classifier.ClassifierResult;
import org.apache.mahout.classifier.bayes.algorithm.BayesAlgorithm;
import org.apache.mahout.classifier.bayes.algorithm.CBayesAlgorithm;
import org.apache.mahout.classifier.bayes.common.BayesParameters;
import org.apache.mahout.classifier.bayes.datastore.InMemoryBayesDatastore;
import org.apache.mahout.classifier.bayes.exceptions.InvalidDatastoreException;
import org.apache.mahout.classifier.bayes.interfaces.Algorithm;
import org.apache.mahout.classifier.bayes.model.ClassifierContext;
import org.apache.mahout.common.StringTuple;
import org.apache.mahout.common.nlp.NGrams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BayesClassifierMapper
extends MapReduceBase
implements Mapper<Text, Text, StringTuple, DoubleWritable> {
    private static final Logger log = LoggerFactory.getLogger(BayesClassifierMapper.class);
    private static final DoubleWritable ONE = new DoubleWritable(1.0);
    private int gramSize = 1;
    private ClassifierContext classifier;
    private String defaultCategory;

    public void map(Text key, Text value, OutputCollector<StringTuple, DoubleWritable> output, Reporter reporter) throws IOException {
        List<String> ngrams = new NGrams(value.toString(), this.gramSize).generateNGramsWithoutLabel();
        try {
            ClassifierResult result = this.classifier.classifyDocument(ngrams.toArray(new String[ngrams.size()]), this.defaultCategory);
            String correctLabel = key.toString();
            String classifiedLabel = result.getLabel();
            StringTuple outputTuple = new StringTuple("__CT");
            outputTuple.add(correctLabel);
            outputTuple.add(classifiedLabel);
            output.collect((Object)outputTuple, (Object)ONE);
        }
        catch (InvalidDatastoreException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure(JobConf job) {
        try {
            void var3_7;
            InMemoryBayesDatastore datastore;
            BayesParameters params = new BayesParameters(job.get("bayes.parameters", ""));
            log.info("Bayes Parameter {}", (Object)params.print());
            log.info("{}", (Object)params.print());
            if (!"hdfs".equals(params.get("dataSource"))) throw new IllegalArgumentException("Unrecognized dataSource type: " + params.get("dataSource"));
            if ("bayes".equalsIgnoreCase(params.get("classifierType"))) {
                log.info("Testing Bayes Classifier");
                BayesAlgorithm bayesAlgorithm = new BayesAlgorithm();
                datastore = new InMemoryBayesDatastore(params);
            } else {
                if (!"cbayes".equalsIgnoreCase(params.get("classifierType"))) throw new IllegalArgumentException("Unrecognized classifier type: " + params.get("classifierType"));
                log.info("Testing Complementary Bayes Classifier");
                CBayesAlgorithm cBayesAlgorithm = new CBayesAlgorithm();
                datastore = new InMemoryBayesDatastore(params);
            }
            this.classifier = new ClassifierContext((Algorithm)var3_7, datastore);
            this.classifier.initialize();
            this.defaultCategory = params.get("defaultCat");
            this.gramSize = params.getGramSize();
            return;
        }
        catch (IOException ex) {
            log.warn(ex.toString(), (Throwable)ex);
            return;
        }
        catch (InvalidDatastoreException e) {
            log.error(e.toString(), (Throwable)e);
        }
    }
}

