/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes.mapreduce.bayes;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.KeyValueTextInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.mahout.classifier.ConfusionMatrix;
import org.apache.mahout.classifier.bayes.mapreduce.bayes.BayesClassifierMapper;
import org.apache.mahout.classifier.bayes.mapreduce.bayes.BayesClassifierReducer;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.Parameters;
import org.apache.mahout.common.StringTuple;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BayesClassifierDriver {
    private static final Logger log = LoggerFactory.getLogger(BayesClassifierDriver.class);

    private BayesClassifierDriver() {
    }

    public static void runJob(Parameters params) throws IOException {
        JobClient client = new JobClient();
        JobConf conf = new JobConf(BayesClassifierDriver.class);
        conf.setJobName("Bayes Classifier Driver running over input: " + params.get("testDirPath"));
        conf.setOutputKeyClass(StringTuple.class);
        conf.setOutputValueClass(DoubleWritable.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path(params.get("testDirPath"))});
        Path outPath = new Path(params.get("testDirPath") + "-output");
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outPath);
        conf.setInputFormat(KeyValueTextInputFormat.class);
        conf.setMapperClass(BayesClassifierMapper.class);
        conf.setCombinerClass(BayesClassifierReducer.class);
        conf.setReducerClass(BayesClassifierReducer.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        HadoopUtil.delete((Configuration)conf, outPath);
        conf.set("bayes.parameters", params.toString());
        client.setConf((Configuration)conf);
        JobClient.runJob((JobConf)conf);
        Path outputFiles = new Path(outPath, "part*");
        ConfusionMatrix matrix = BayesClassifierDriver.readResult(outputFiles, (Configuration)conf, params);
        log.info("{}", (Object)matrix);
    }

    public static ConfusionMatrix readResult(Path pathPattern, Configuration conf, Parameters params) {
        String defaultLabel = params.get("defaultCat");
        HashMap confusionMatrix = new HashMap();
        for (Pair record : new SequenceFileDirIterable(pathPattern, PathType.GLOB, null, null, true, conf)) {
            StringTuple key = (StringTuple)record.getFirst();
            DoubleWritable value = (DoubleWritable)record.getSecond();
            String correctLabel = key.stringAt(1);
            String classifiedLabel = key.stringAt(2);
            HashMap<String, Integer> rowMatrix = (HashMap<String, Integer>)confusionMatrix.get(correctLabel);
            if (rowMatrix == null) {
                rowMatrix = new HashMap<String, Integer>();
            }
            Integer count = Double.valueOf(value.get()).intValue();
            rowMatrix.put(classifiedLabel, count);
            confusionMatrix.put(correctLabel, rowMatrix);
        }
        ConfusionMatrix matrix = new ConfusionMatrix(confusionMatrix.keySet(), defaultLabel);
        for (Map.Entry correctLabelSet : confusionMatrix.entrySet()) {
            Map rowMatrix = (Map)correctLabelSet.getValue();
            for (Map.Entry classifiedLabelSet : rowMatrix.entrySet()) {
                matrix.addInstance((String)correctLabelSet.getKey(), (String)classifiedLabelSet.getKey());
                matrix.putCount((String)correctLabelSet.getKey(), (String)classifiedLabelSet.getKey(), (Integer)classifiedLabelSet.getValue());
            }
        }
        return matrix;
    }
}

