/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes.io;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.mahout.classifier.bayes.datastore.InMemoryBayesDatastore;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.Parameters;
import org.apache.mahout.common.StringTuple;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SequenceFileModelReader {
    private static final Logger log = LoggerFactory.getLogger(SequenceFileModelReader.class);

    private SequenceFileModelReader() {
    }

    public static void loadModel(InMemoryBayesDatastore datastore, Parameters params, Configuration conf) {
        SequenceFileModelReader.loadFeatureWeights(datastore, new Path(params.get("sigma_j")), conf);
        SequenceFileModelReader.loadLabelWeights(datastore, new Path(params.get("sigma_k")), conf);
        SequenceFileModelReader.loadSumWeight(datastore, new Path(params.get("sigma_kSigma_j")), conf);
        SequenceFileModelReader.loadThetaNormalizer(datastore, new Path(params.get("thetaNormalizer")), conf);
        SequenceFileModelReader.loadWeightMatrix(datastore, new Path(params.get("weight")), conf);
    }

    public static void loadWeightMatrix(InMemoryBayesDatastore datastore, Path pathPattern, Configuration conf) {
        for (Pair record : new SequenceFileDirIterable(pathPattern, PathType.GLOB, null, null, true, conf)) {
            StringTuple key = (StringTuple)record.getFirst();
            DoubleWritable value = (DoubleWritable)record.getSecond();
            datastore.loadFeatureWeight(key.stringAt(2), key.stringAt(1), value.get());
        }
    }

    public static void loadFeatureWeights(InMemoryBayesDatastore datastore, Path pathPattern, Configuration conf) {
        long count = 0L;
        for (Pair record : new SequenceFileDirIterable(pathPattern, PathType.GLOB, null, null, true, conf)) {
            StringTuple key = (StringTuple)record.getFirst();
            DoubleWritable value = (DoubleWritable)record.getSecond();
            if (!key.stringAt(0).equals("__SJ")) continue;
            datastore.setSumFeatureWeight(key.stringAt(1), value.get());
            if (++count % 50000L != 0L) continue;
            log.info("Read {} feature weights", (Object)count);
        }
    }

    public static void loadLabelWeights(InMemoryBayesDatastore datastore, Path pathPattern, Configuration conf) {
        long count = 0L;
        for (Pair record : new SequenceFileDirIterable(pathPattern, PathType.GLOB, null, null, true, conf)) {
            StringTuple key = (StringTuple)record.getFirst();
            DoubleWritable value = (DoubleWritable)record.getSecond();
            if (!key.stringAt(0).equals("__SK")) continue;
            datastore.setSumLabelWeight(key.stringAt(1), value.get());
            if (++count % 10000L != 0L) continue;
            log.info("Read {} label weights", (Object)count);
        }
    }

    public static void loadThetaNormalizer(InMemoryBayesDatastore datastore, Path pathPattern, Configuration conf) {
        long count = 0L;
        for (Pair record : new SequenceFileDirIterable(pathPattern, PathType.GLOB, null, null, true, conf)) {
            StringTuple key = (StringTuple)record.getFirst();
            DoubleWritable value = (DoubleWritable)record.getSecond();
            if (!key.stringAt(0).equals("_LTN")) continue;
            datastore.setThetaNormalizer(key.stringAt(1), value.get());
            if (++count % 50000L != 0L) continue;
            log.info("Read {} theta norms", (Object)count);
        }
    }

    public static void loadSumWeight(InMemoryBayesDatastore datastore, Path pathPattern, Configuration conf) {
        for (Pair record : new SequenceFileDirIterable(pathPattern, PathType.GLOB, null, null, true, conf)) {
            StringTuple key = (StringTuple)record.getFirst();
            DoubleWritable value = (DoubleWritable)record.getSecond();
            if (!key.stringAt(0).equals("_SJSK")) continue;
            datastore.setSigmaJSigmaK(value.get());
            log.info("{}", (Object)value.get());
        }
    }

    public static Map<String, Double> readLabelSums(Path pathPattern, Configuration conf) {
        HashMap<String, Double> labelSum = new HashMap<String, Double>();
        for (Pair record : new SequenceFileDirIterable(pathPattern, PathType.GLOB, null, null, true, conf)) {
            StringTuple key = (StringTuple)record.getFirst();
            DoubleWritable value = (DoubleWritable)record.getSecond();
            if (!key.stringAt(0).equals("__SK")) continue;
            labelSum.put(key.stringAt(1), value.get());
        }
        return labelSum;
    }

    public static Map<String, Double> readLabelDocumentCounts(Path pathPattern, Configuration conf) {
        HashMap<String, Double> labelDocumentCounts = new HashMap<String, Double>();
        for (Pair record : new SequenceFileDirIterable(pathPattern, PathType.GLOB, null, null, true, conf)) {
            StringTuple key = (StringTuple)record.getFirst();
            DoubleWritable value = (DoubleWritable)record.getSecond();
            if (!key.stringAt(0).equals("__LC")) continue;
            labelDocumentCounts.put(key.stringAt(1), value.get());
        }
        return labelDocumentCounts;
    }

    public static double readSigmaJSigmaK(Path pathPattern, Configuration conf) {
        HashMap<String, Double> weightSum = new HashMap<String, Double>();
        for (Pair record : new SequenceFileDirIterable(pathPattern, PathType.GLOB, null, null, true, conf)) {
            StringTuple key = (StringTuple)record.getFirst();
            DoubleWritable value = (DoubleWritable)record.getSecond();
            if (weightSum.size() > 1) {
                throw new IllegalStateException("Incorrect Sum File");
            }
            if (!key.stringAt(0).equals("_SJSK")) continue;
            weightSum.put("_SJSK", value.get());
        }
        return (Double)weightSum.get("_SJSK");
    }

    public static double readVocabCount(Path pathPattern, Configuration conf) {
        HashMap<String, Double> weightSum = new HashMap<String, Double>();
        for (Pair record : new SequenceFileDirIterable(pathPattern, PathType.GLOB, null, null, true, conf)) {
            if (weightSum.size() > 1) {
                throw new IllegalStateException("Incorrect vocabCount File");
            }
            StringTuple key = (StringTuple)record.getFirst();
            DoubleWritable value = (DoubleWritable)record.getSecond();
            if (!key.stringAt(0).equals("__FS")) continue;
            weightSum.put("__FS", value.get());
        }
        return (Double)weightSum.get("__FS");
    }
}

