/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes.algorithm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.PriorityQueue;
import org.apache.commons.lang.mutable.MutableDouble;
import org.apache.mahout.classifier.ClassifierResult;
import org.apache.mahout.classifier.bayes.common.ByScoreLabelResultComparator;
import org.apache.mahout.classifier.bayes.exceptions.InvalidDatastoreException;
import org.apache.mahout.classifier.bayes.interfaces.Algorithm;
import org.apache.mahout.classifier.bayes.interfaces.Datastore;
import org.apache.mahout.math.function.ObjectIntProcedure;
import org.apache.mahout.math.map.OpenObjectIntHashMap;

public class BayesAlgorithm
implements Algorithm {
    @Override
    public ClassifierResult classifyDocument(String[] document, Datastore datastore, String defaultCategory) throws InvalidDatastoreException {
        ClassifierResult result = new ClassifierResult(defaultCategory);
        double max = Double.MAX_VALUE;
        Collection<String> categories = datastore.getKeys("labelWeight");
        for (String category : categories) {
            double prob = this.documentWeight(datastore, category, document);
            if (!(prob < max)) continue;
            max = prob;
            result.setLabel(category);
        }
        result.setScore(max);
        return result;
    }

    @Override
    public ClassifierResult[] classifyDocument(String[] document, Datastore datastore, String defaultCategory, int numResults) throws InvalidDatastoreException {
        Collection<String> categories = datastore.getKeys("labelWeight");
        PriorityQueue<ClassifierResult> pq = new PriorityQueue<ClassifierResult>(numResults, new ByScoreLabelResultComparator());
        for (String category : categories) {
            double prob = this.documentWeight(datastore, category, document);
            if (!(prob > 0.0)) continue;
            pq.add(new ClassifierResult(category, prob));
            if (pq.size() <= numResults) continue;
            pq.remove();
        }
        if (pq.isEmpty()) {
            return new ClassifierResult[]{new ClassifierResult(defaultCategory, 0.0)};
        }
        ArrayList result = new ArrayList(pq.size());
        while (!pq.isEmpty()) {
            result.add(pq.remove());
        }
        Collections.reverse(result);
        return result.toArray(new ClassifierResult[pq.size()]);
    }

    @Override
    public double featureWeight(Datastore datastore, String label, String feature) throws InvalidDatastoreException {
        double result = datastore.getWeight("weight", feature, label);
        double vocabCount = datastore.getWeight("sumWeight", "vocabCount");
        double sumLabelWeight = datastore.getWeight("labelWeight", label);
        double numerator = result + datastore.getWeight("params", "alpha_i");
        double denominator = sumLabelWeight + vocabCount;
        double weight = Math.log(numerator / denominator);
        return -weight;
    }

    @Override
    public void initialize(Datastore datastore) throws InvalidDatastoreException {
        datastore.getKeys("labelWeight");
    }

    @Override
    public double documentWeight(final Datastore datastore, final String label, String[] document) {
        OpenObjectIntHashMap wordList = new OpenObjectIntHashMap(document.length / 2);
        for (String word : document) {
            if (wordList.containsKey((Object)word)) {
                wordList.put((Object)word, wordList.get((Object)word) + 1);
                continue;
            }
            wordList.put((Object)word, 1);
        }
        final MutableDouble result = new MutableDouble(0.0);
        wordList.forEachPair((ObjectIntProcedure)new ObjectIntProcedure<String>(){

            public boolean apply(String word, int frequency) {
                try {
                    result.add((double)frequency * BayesAlgorithm.this.featureWeight(datastore, label, word));
                }
                catch (InvalidDatastoreException e) {
                    throw new IllegalStateException(e);
                }
                return true;
            }
        });
        return result.doubleValue();
    }

    @Override
    public Collection<String> getLabels(Datastore datastore) throws InvalidDatastoreException {
        return datastore.getKeys("labelWeight");
    }
}

