/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes;

import java.io.IOException;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.classifier.bayes.common.BayesParameters;
import org.apache.mahout.classifier.bayes.mapreduce.bayes.BayesDriver;
import org.apache.mahout.classifier.bayes.mapreduce.cbayes.CBayesDriver;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TrainClassifier {
    private static final Logger log = LoggerFactory.getLogger(TrainClassifier.class);

    private TrainClassifier() {
    }

    public static void trainNaiveBayes(Path dir, Path outputDir, BayesParameters params) throws IOException {
        BayesDriver driver = new BayesDriver();
        driver.runJob(dir, outputDir, params);
    }

    public static void trainCNaiveBayes(Path dir, Path outputDir, BayesParameters params) throws IOException {
        CBayesDriver driver = new CBayesDriver();
        driver.runJob(dir, outputDir, params);
    }

    public static void main(String[] args) throws Exception {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        Option helpOpt = DefaultOptionCreator.helpOption();
        DefaultOption inputDirOpt = obuilder.withLongName("input").withRequired(true).withArgument(abuilder.withName("input").withMinimum(1).withMaximum(1).create()).withDescription("The Directory on HDFS containing the collapsed, properly formatted files: One doc per line, first entry on the line is the label, rest is the evidence").withShortName("i").create();
        DefaultOption outputOpt = obuilder.withLongName("output").withRequired(true).withArgument(abuilder.withName("output").withMinimum(1).withMaximum(1).create()).withDescription("The location of the model on the HDFS").withShortName("o").create();
        DefaultOption gramSizeOpt = obuilder.withLongName("gramSize").withRequired(false).withArgument(abuilder.withName("gramSize").withMinimum(1).withMaximum(1).create()).withDescription("Size of the n-gram. Default Value: 1 ").withShortName("ng").create();
        DefaultOption minDfOpt = obuilder.withLongName("minDf").withRequired(false).withArgument(abuilder.withName("minDf").withMinimum(1).withMaximum(1).create()).withDescription("Minimum Term Document Frequency: 1 ").withShortName("mf").create();
        DefaultOption minSupportOpt = obuilder.withLongName("minSupport").withRequired(false).withArgument(abuilder.withName("minSupport").withMinimum(1).withMaximum(1).create()).withDescription("Minimum Support (Term Frequency): 1 ").withShortName("ms").create();
        DefaultOption alphaOpt = obuilder.withLongName("alpha").withRequired(false).withArgument(abuilder.withName("a").withMinimum(1).withMaximum(1).create()).withDescription("Smoothing parameter Default Value: 1.0").withShortName("a").create();
        DefaultOption typeOpt = obuilder.withLongName("classifierType").withRequired(false).withArgument(abuilder.withName("classifierType").withMinimum(1).withMaximum(1).create()).withDescription("Type of classifier: bayes|cbayes. Default: bayes").withShortName("type").create();
        DefaultOption dataSourceOpt = obuilder.withLongName("dataSource").withRequired(false).withArgument(abuilder.withName("dataSource").withMinimum(1).withMaximum(1).create()).withDescription("Location of model: hdfs. Default Value: hdfs").withShortName("source").create();
        DefaultOption skipCleanupOpt = obuilder.withLongName("skipCleanup").withRequired(false).withDescription("Skip cleanup of feature extraction output").withShortName("sc").create();
        Group group = gbuilder.withName("Options").withOption((Option)gramSizeOpt).withOption(helpOpt).withOption((Option)inputDirOpt).withOption((Option)outputOpt).withOption((Option)typeOpt).withOption((Option)dataSourceOpt).withOption((Option)alphaOpt).withOption((Option)minDfOpt).withOption((Option)minSupportOpt).withOption((Option)skipCleanupOpt).create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            parser.setHelpOption(helpOpt);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption(helpOpt)) {
                CommandLineUtil.printHelp(group);
                return;
            }
            String classifierType = (String)cmdLine.getValue((Option)typeOpt);
            String dataSourceType = (String)cmdLine.getValue((Option)dataSourceOpt);
            BayesParameters params = new BayesParameters();
            params.setGramSize(1);
            params.setMinDF(1);
            params.set("alpha_i", "1.0");
            params.set("dataSource", "hdfs");
            if (cmdLine.hasOption((Option)gramSizeOpt)) {
                params.setGramSize(Integer.parseInt((String)cmdLine.getValue((Option)gramSizeOpt)));
            }
            if (cmdLine.hasOption((Option)minDfOpt)) {
                params.setMinDF(Integer.parseInt((String)cmdLine.getValue((Option)minDfOpt)));
            }
            if (cmdLine.hasOption((Option)minSupportOpt)) {
                params.setMinSupport(Integer.parseInt((String)cmdLine.getValue((Option)minSupportOpt)));
            }
            if (cmdLine.hasOption((Option)skipCleanupOpt)) {
                params.setSkipCleanup(true);
            }
            if (cmdLine.hasOption((Option)alphaOpt)) {
                params.set("alpha_i", (String)cmdLine.getValue((Option)alphaOpt));
            }
            if (cmdLine.hasOption((Option)dataSourceOpt)) {
                params.set("dataSource", dataSourceType);
            }
            Path inputPath = new Path((String)cmdLine.getValue((Option)inputDirOpt));
            Path outputPath = new Path((String)cmdLine.getValue((Option)outputOpt));
            if ("cbayes".equalsIgnoreCase(classifierType)) {
                log.info("Training Complementary Bayes Classifier");
                TrainClassifier.trainCNaiveBayes(inputPath, outputPath, params);
            } else {
                log.info("Training Bayes Classifier");
                TrainClassifier.trainNaiveBayes(inputPath, outputPath, params);
            }
        }
        catch (OptionException e) {
            log.error("Error while parsing options", (Throwable)e);
            CommandLineUtil.printHelp(group);
        }
    }
}

