/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.bayes;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.mahout.classifier.ClassifierResult;
import org.apache.mahout.classifier.ResultAnalyzer;
import org.apache.mahout.classifier.bayes.algorithm.BayesAlgorithm;
import org.apache.mahout.classifier.bayes.algorithm.CBayesAlgorithm;
import org.apache.mahout.classifier.bayes.common.BayesParameters;
import org.apache.mahout.classifier.bayes.datastore.InMemoryBayesDatastore;
import org.apache.mahout.classifier.bayes.exceptions.InvalidDatastoreException;
import org.apache.mahout.classifier.bayes.interfaces.Algorithm;
import org.apache.mahout.classifier.bayes.mapreduce.bayes.BayesClassifierDriver;
import org.apache.mahout.classifier.bayes.model.ClassifierContext;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.TimingStatistics;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.apache.mahout.common.nlp.NGrams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestClassifier {
    private static final Logger log = LoggerFactory.getLogger(TestClassifier.class);

    private TestClassifier() {
    }

    public static void main(String[] args) throws IOException, InvalidDatastoreException {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption pathOpt = obuilder.withLongName("model").withRequired(true).withArgument(abuilder.withName("model").withMinimum(1).withMaximum(1).create()).withDescription("The path on HDFS as defined by the -source parameter").withShortName("m").create();
        DefaultOption dirOpt = obuilder.withLongName("testDir").withRequired(true).withArgument(abuilder.withName("testDir").withMinimum(1).withMaximum(1).create()).withDescription("The directory where test documents resides in").withShortName("d").create();
        Option helpOpt = DefaultOptionCreator.helpOption();
        DefaultOption encodingOpt = obuilder.withLongName("encoding").withArgument(abuilder.withName("encoding").withMinimum(1).withMaximum(1).create()).withDescription("The file encoding.  Defaults to UTF-8").withShortName("e").create();
        DefaultOption defaultCatOpt = obuilder.withLongName("defaultCat").withArgument(abuilder.withName("defaultCat").withMinimum(1).withMaximum(1).create()).withDescription("The default category Default Value: unknown").withShortName("default").create();
        DefaultOption gramSizeOpt = obuilder.withLongName("gramSize").withRequired(false).withArgument(abuilder.withName("gramSize").withMinimum(1).withMaximum(1).create()).withDescription("Size of the n-gram. Default Value: 1").withShortName("ng").create();
        DefaultOption alphaOpt = obuilder.withLongName("alpha").withRequired(false).withArgument(abuilder.withName("a").withMinimum(1).withMaximum(1).create()).withDescription("Smoothing parameter Default Value: 1.0").withShortName("a").create();
        DefaultOption verboseOutputOpt = obuilder.withLongName("verbose").withRequired(false).withDescription("Output which values were correctly and incorrectly classified").withShortName("v").create();
        DefaultOption typeOpt = obuilder.withLongName("classifierType").withRequired(false).withArgument(abuilder.withName("classifierType").withMinimum(1).withMaximum(1).create()).withDescription("Type of classifier: bayes|cbayes. Default Value: bayes").withShortName("type").create();
        DefaultOption dataSourceOpt = obuilder.withLongName("dataSource").withRequired(false).withArgument(abuilder.withName("dataSource").withMinimum(1).withMaximum(1).create()).withDescription("Location of model: hdfs").withShortName("source").create();
        DefaultOption methodOpt = obuilder.withLongName("method").withRequired(false).withArgument(abuilder.withName("method").withMinimum(1).withMaximum(1).create()).withDescription("Method of Classification: sequential|mapreduce. Default Value: sequential").withShortName("method").create();
        Group group = gbuilder.withName("Options").withOption((Option)defaultCatOpt).withOption((Option)dirOpt).withOption((Option)encodingOpt).withOption((Option)gramSizeOpt).withOption((Option)pathOpt).withOption((Option)typeOpt).withOption((Option)dataSourceOpt).withOption(helpOpt).withOption((Option)methodOpt).withOption((Option)verboseOutputOpt).withOption((Option)alphaOpt).create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption(helpOpt)) {
                CommandLineUtil.printHelp(group);
                return;
            }
            BayesParameters params = new BayesParameters();
            int gramSize = 1;
            String modelBasePath = (String)cmdLine.getValue((Option)pathOpt);
            if (cmdLine.hasOption((Option)gramSizeOpt)) {
                gramSize = Integer.parseInt((String)cmdLine.getValue((Option)gramSizeOpt));
            }
            String classifierType = "bayes";
            if (cmdLine.hasOption((Option)typeOpt)) {
                classifierType = (String)cmdLine.getValue((Option)typeOpt);
            }
            String dataSource = "hdfs";
            if (cmdLine.hasOption((Option)dataSourceOpt)) {
                dataSource = (String)cmdLine.getValue((Option)dataSourceOpt);
            }
            String defaultCat = "unknown";
            if (cmdLine.hasOption((Option)defaultCatOpt)) {
                defaultCat = (String)cmdLine.getValue((Option)defaultCatOpt);
            }
            String encoding = "UTF-8";
            if (cmdLine.hasOption((Option)encodingOpt)) {
                encoding = (String)cmdLine.getValue((Option)encodingOpt);
            }
            String alphaI = "1.0";
            if (cmdLine.hasOption((Option)alphaOpt)) {
                alphaI = (String)cmdLine.getValue((Option)alphaOpt);
            }
            boolean verbose = cmdLine.hasOption((Option)verboseOutputOpt);
            String testDirPath = (String)cmdLine.getValue((Option)dirOpt);
            String classificationMethod = "sequential";
            if (cmdLine.hasOption((Option)methodOpt)) {
                classificationMethod = (String)cmdLine.getValue((Option)methodOpt);
            }
            params.setGramSize(gramSize);
            params.set("verbose", Boolean.toString(verbose));
            params.setBasePath(modelBasePath);
            params.set("classifierType", classifierType);
            params.set("dataSource", dataSource);
            params.set("defaultCat", defaultCat);
            params.set("encoding", encoding);
            params.set("alpha_i", alphaI);
            params.set("testDirPath", testDirPath);
            if ("sequential".equalsIgnoreCase(classificationMethod)) {
                TestClassifier.classifySequential(params);
            } else if ("mapreduce".equalsIgnoreCase(classificationMethod)) {
                TestClassifier.classifyParallel(params);
            }
        }
        catch (OptionException e) {
            CommandLineUtil.printHelp(group);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void classifySequential(BayesParameters params) throws IOException, InvalidDatastoreException {
        void var4_6;
        InMemoryBayesDatastore datastore;
        log.info("Loading model from: {}", (Object)params.print());
        boolean verbose = Boolean.valueOf(params.get("verbose"));
        File dir = new File(params.get("testDirPath"));
        File[] subdirs = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return !s.startsWith(".");
            }
        });
        if (!"hdfs".equals(params.get("dataSource"))) throw new IllegalArgumentException("Unrecognized dataSource type: " + params.get("dataSource"));
        if ("bayes".equalsIgnoreCase(params.get("classifierType"))) {
            log.info("Testing Bayes Classifier");
            BayesAlgorithm bayesAlgorithm = new BayesAlgorithm();
            datastore = new InMemoryBayesDatastore(params);
        } else {
            if (!"cbayes".equalsIgnoreCase(params.get("classifierType"))) throw new IllegalArgumentException("Unrecognized classifier type: " + params.get("classifierType"));
            log.info("Testing Complementary Bayes Classifier");
            CBayesAlgorithm cBayesAlgorithm = new CBayesAlgorithm();
            datastore = new InMemoryBayesDatastore(params);
        }
        ClassifierContext classifier = new ClassifierContext((Algorithm)var4_6, datastore);
        classifier.initialize();
        ResultAnalyzer resultAnalyzer = new ResultAnalyzer(classifier.getLabels(), params.get("defaultCat"));
        TimingStatistics totalStatistics = new TimingStatistics();
        if (subdirs != null) {
            for (File file : subdirs) {
                if (verbose) {
                    log.info("--------------");
                    log.info("Testing: {}", (Object)file);
                }
                TimingStatistics operationStats = new TimingStatistics();
                long lineNum = 0L;
                for (String line : new FileLineIterable(new File(file.getPath()), Charset.forName(params.get("encoding")), false)) {
                    Map<String, List<String>> document = new NGrams(line, Integer.parseInt(params.get("gramSize"))).generateNGrams();
                    for (Map.Entry<String, List<String>> stringListEntry : document.entrySet()) {
                        String correctLabel = stringListEntry.getKey();
                        List<String> strings = stringListEntry.getValue();
                        TimingStatistics.Call call = operationStats.newCall();
                        TimingStatistics.Call outercall = totalStatistics.newCall();
                        ClassifierResult classifiedLabel = classifier.classifyDocument(strings.toArray(new String[strings.size()]), params.get("defaultCat"));
                        call.end();
                        outercall.end();
                        boolean correct = resultAnalyzer.addInstance(correctLabel, classifiedLabel);
                        if (!verbose) continue;
                        log.info("Line Number: {} Line(30): {} Expected Label: {} Classified Label: {} Correct: {}", new Object[]{lineNum, line.length() > 30 ? line.substring(0, 30) : line, correctLabel, classifiedLabel.getLabel(), correct});
                    }
                    ++lineNum;
                }
                log.info("Classified instances from {}", (Object)file.getName());
                if (!verbose) continue;
                log.info("Performance stats {}", (Object)operationStats.toString());
            }
        }
        if (verbose) {
            log.info("{}", (Object)totalStatistics);
        }
        log.info("{}", (Object)resultAnalyzer);
    }

    public static void classifyParallel(BayesParameters params) throws IOException {
        BayesClassifierDriver.runJob(params);
    }
}

