/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier;

import java.text.DecimalFormat;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.mahout.classifier.ClassifierResult;
import org.apache.mahout.classifier.ConfusionMatrix;

public class ResultAnalyzer {
    private final ConfusionMatrix confusionMatrix;
    private int correctlyClassified;
    private int incorrectlyClassified;

    public ResultAnalyzer(Collection<String> labelSet, String defaultLabel) {
        this.confusionMatrix = new ConfusionMatrix(labelSet, defaultLabel);
    }

    public ConfusionMatrix getConfusionMatrix() {
        return this.confusionMatrix;
    }

    public boolean addInstance(String correctLabel, ClassifierResult classifiedResult) {
        boolean result = correctLabel.equals(classifiedResult.getLabel());
        if (result) {
            ++this.correctlyClassified;
        } else {
            ++this.incorrectlyClassified;
        }
        this.confusionMatrix.addInstance(correctLabel, classifiedResult);
        return result;
    }

    public String toString() {
        StringBuilder returnString = new StringBuilder();
        returnString.append("=======================================================\n");
        returnString.append("Summary\n");
        returnString.append("-------------------------------------------------------\n");
        int totalClassified = this.correctlyClassified + this.incorrectlyClassified;
        double percentageCorrect = 100.0 * (double)this.correctlyClassified / (double)totalClassified;
        double percentageIncorrect = 100.0 * (double)this.incorrectlyClassified / (double)totalClassified;
        DecimalFormat decimalFormatter = new DecimalFormat("0.####");
        returnString.append(StringUtils.rightPad((String)"Correctly Classified Instances", (int)40)).append(": ").append(StringUtils.leftPad((String)Integer.toString(this.correctlyClassified), (int)10)).append('\t').append(StringUtils.leftPad((String)decimalFormatter.format(percentageCorrect), (int)10)).append("%\n");
        returnString.append(StringUtils.rightPad((String)"Incorrectly Classified Instances", (int)40)).append(": ").append(StringUtils.leftPad((String)Integer.toString(this.incorrectlyClassified), (int)10)).append('\t').append(StringUtils.leftPad((String)decimalFormatter.format(percentageIncorrect), (int)10)).append("%\n");
        returnString.append(StringUtils.rightPad((String)"Total Classified Instances", (int)40)).append(": ").append(StringUtils.leftPad((String)Integer.toString(totalClassified), (int)10)).append('\n');
        returnString.append('\n');
        returnString.append(this.confusionMatrix);
        return returnString.toString();
    }
}

