/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.mahout.classifier.ClassifierResult;

public class ConfusionMatrix {
    private final Map<String, Integer> labelMap = new LinkedHashMap<String, Integer>();
    private final int[][] confusionMatrix;
    private String defaultLabel = "unknown";

    public ConfusionMatrix(Collection<String> labels, String defaultLabel) {
        this.confusionMatrix = new int[labels.size() + 1][labels.size() + 1];
        this.defaultLabel = defaultLabel;
        for (String label : labels) {
            this.labelMap.put(label, this.labelMap.size());
        }
        this.labelMap.put(defaultLabel, this.labelMap.size());
    }

    public int[][] getConfusionMatrix() {
        return this.confusionMatrix;
    }

    public Collection<String> getLabels() {
        return Collections.unmodifiableCollection(this.labelMap.keySet());
    }

    public double getAccuracy(String label) {
        int labelId = this.labelMap.get(label);
        int labelTotal = 0;
        int correct = 0;
        for (int i = 0; i < this.labelMap.size(); ++i) {
            labelTotal += this.confusionMatrix[labelId][i];
            if (i != labelId) continue;
            correct = this.confusionMatrix[labelId][i];
        }
        return 100.0 * (double)correct / (double)labelTotal;
    }

    public int getCorrect(String label) {
        int labelId = this.labelMap.get(label);
        return this.confusionMatrix[labelId][labelId];
    }

    public double getTotal(String label) {
        int labelId = this.labelMap.get(label);
        int labelTotal = 0;
        for (int i = 0; i < this.labelMap.size(); ++i) {
            labelTotal += this.confusionMatrix[labelId][i];
        }
        return labelTotal;
    }

    public void addInstance(String correctLabel, ClassifierResult classifiedResult) {
        this.incrementCount(correctLabel, classifiedResult.getLabel());
    }

    public void addInstance(String correctLabel, String classifiedLabel) {
        this.incrementCount(correctLabel, classifiedLabel);
    }

    public int getCount(String correctLabel, String classifiedLabel) {
        Preconditions.checkArgument((boolean)this.labelMap.containsKey(correctLabel), (Object)("Label not found: " + correctLabel));
        Preconditions.checkArgument((boolean)this.labelMap.containsKey(classifiedLabel), (Object)("Label not found: " + classifiedLabel));
        int correctId = this.labelMap.get(correctLabel);
        int classifiedId = this.labelMap.get(classifiedLabel);
        return this.confusionMatrix[correctId][classifiedId];
    }

    public void putCount(String correctLabel, String classifiedLabel, int count) {
        Preconditions.checkArgument((boolean)this.labelMap.containsKey(correctLabel), (Object)("Label not found: " + correctLabel));
        Preconditions.checkArgument((boolean)this.labelMap.containsKey(classifiedLabel), (Object)("Label not found: " + classifiedLabel));
        int correctId = this.labelMap.get(correctLabel);
        int classifiedId = this.labelMap.get(classifiedLabel);
        this.confusionMatrix[correctId][classifiedId] = count;
    }

    public void incrementCount(String correctLabel, String classifiedLabel, int count) {
        this.putCount(correctLabel, classifiedLabel, count + this.getCount(correctLabel, classifiedLabel));
    }

    public void incrementCount(String correctLabel, String classifiedLabel) {
        this.incrementCount(correctLabel, classifiedLabel, 1);
    }

    public ConfusionMatrix merge(ConfusionMatrix b) {
        Preconditions.checkArgument((this.labelMap.size() == b.getLabels().size() ? 1 : 0) != 0, (Object)"The label sizes do not match");
        for (String correctLabel : this.labelMap.keySet()) {
            for (String classifiedLabel : this.labelMap.keySet()) {
                this.incrementCount(correctLabel, classifiedLabel, b.getCount(correctLabel, classifiedLabel));
            }
        }
        return this;
    }

    public String toString() {
        StringBuilder returnString = new StringBuilder(200);
        returnString.append("=======================================================").append('\n');
        returnString.append("Confusion Matrix\n");
        returnString.append("-------------------------------------------------------").append('\n');
        for (Map.Entry<String, Integer> entry : this.labelMap.entrySet()) {
            returnString.append(StringUtils.rightPad((String)ConfusionMatrix.getSmallLabel(entry.getValue()), (int)5)).append('\t');
        }
        returnString.append("<--Classified as").append('\n');
        for (Map.Entry<String, Integer> entry : this.labelMap.entrySet()) {
            String correctLabel = entry.getKey();
            int labelTotal = 0;
            for (String classifiedLabel : this.labelMap.keySet()) {
                returnString.append(StringUtils.rightPad((String)Integer.toString(this.getCount(correctLabel, classifiedLabel)), (int)5)).append('\t');
                labelTotal += this.getCount(correctLabel, classifiedLabel);
            }
            returnString.append(" |  ").append(StringUtils.rightPad((String)String.valueOf(labelTotal), (int)6)).append('\t').append(StringUtils.rightPad((String)ConfusionMatrix.getSmallLabel(entry.getValue()), (int)5)).append(" = ").append(correctLabel).append('\n');
        }
        returnString.append("Default Category: ").append(this.defaultLabel).append(": ").append(this.labelMap.get(this.defaultLabel)).append('\n');
        returnString.append('\n');
        return returnString.toString();
    }

    static String getSmallLabel(int i) {
        int val = i;
        StringBuilder returnString = new StringBuilder();
        do {
            int n = val % 26;
            returnString.insert(0, (char)(97 + n));
        } while ((val /= 26) > 0);
        return returnString.toString();
    }
}

