/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier;

import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;
import org.apache.mahout.classifier.BayesFileFormatter;
import org.apache.mahout.classifier.ClassifierResult;
import org.apache.mahout.classifier.bayes.algorithm.BayesAlgorithm;
import org.apache.mahout.classifier.bayes.algorithm.CBayesAlgorithm;
import org.apache.mahout.classifier.bayes.common.BayesParameters;
import org.apache.mahout.classifier.bayes.datastore.InMemoryBayesDatastore;
import org.apache.mahout.classifier.bayes.interfaces.Algorithm;
import org.apache.mahout.classifier.bayes.model.ClassifierContext;
import org.apache.mahout.common.nlp.NGrams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Classify {
    private static final Logger log = LoggerFactory.getLogger(Classify.class);

    private Classify() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        void var18_22;
        InMemoryBayesDatastore datastore;
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption pathOpt = obuilder.withLongName("path").withRequired(true).withArgument(abuilder.withName("path").withMinimum(1).withMaximum(1).create()).withDescription("The local file system path").withShortName("m").create();
        DefaultOption classifyOpt = obuilder.withLongName("classify").withRequired(true).withArgument(abuilder.withName("classify").withMinimum(1).withMaximum(1).create()).withDescription("The doc to classify").withShortName("").create();
        DefaultOption encodingOpt = obuilder.withLongName("encoding").withRequired(true).withArgument(abuilder.withName("encoding").withMinimum(1).withMaximum(1).create()).withDescription("The file encoding.  Default: UTF-8").withShortName("e").create();
        DefaultOption analyzerOpt = obuilder.withLongName("analyzer").withRequired(true).withArgument(abuilder.withName("analyzer").withMinimum(1).withMaximum(1).create()).withDescription("The Analyzer to use").withShortName("a").create();
        DefaultOption defaultCatOpt = obuilder.withLongName("defaultCat").withRequired(true).withArgument(abuilder.withName("defaultCat").withMinimum(1).withMaximum(1).create()).withDescription("The default category").withShortName("d").create();
        DefaultOption gramSizeOpt = obuilder.withLongName("gramSize").withRequired(true).withArgument(abuilder.withName("gramSize").withMinimum(1).withMaximum(1).create()).withDescription("Size of the n-gram").withShortName("ng").create();
        DefaultOption typeOpt = obuilder.withLongName("classifierType").withRequired(true).withArgument(abuilder.withName("classifierType").withMinimum(1).withMaximum(1).create()).withDescription("Type of classifier").withShortName("type").create();
        DefaultOption dataSourceOpt = obuilder.withLongName("dataSource").withRequired(true).withArgument(abuilder.withName("dataSource").withMinimum(1).withMaximum(1).create()).withDescription("Location of model: hdfs").withShortName("source").create();
        Group options = gbuilder.withName("Options").withOption((Option)pathOpt).withOption((Option)classifyOpt).withOption((Option)encodingOpt).withOption((Option)analyzerOpt).withOption((Option)defaultCatOpt).withOption((Option)gramSizeOpt).withOption((Option)typeOpt).withOption((Option)dataSourceOpt).create();
        Parser parser = new Parser();
        parser.setGroup(options);
        CommandLine cmdLine = parser.parse(args);
        int gramSize = 1;
        if (cmdLine.hasOption((Option)gramSizeOpt)) {
            gramSize = Integer.parseInt((String)cmdLine.getValue((Option)gramSizeOpt));
        }
        BayesParameters params = new BayesParameters();
        params.setGramSize(gramSize);
        String modelBasePath = (String)cmdLine.getValue((Option)pathOpt);
        params.setBasePath(modelBasePath);
        log.info("Loading model from: {}", (Object)params.print());
        String classifierType = (String)cmdLine.getValue((Option)typeOpt);
        String dataSource = (String)cmdLine.getValue((Option)dataSourceOpt);
        if (!"hdfs".equals(dataSource)) throw new IllegalArgumentException("Unrecognized dataSource type: " + dataSource);
        if ("bayes".equalsIgnoreCase(classifierType)) {
            log.info("Using Bayes Classifier");
            BayesAlgorithm bayesAlgorithm = new BayesAlgorithm();
            datastore = new InMemoryBayesDatastore(params);
        } else {
            if (!"cbayes".equalsIgnoreCase(classifierType)) throw new IllegalArgumentException("Unrecognized classifier type: " + classifierType);
            log.info("Using Complementary Bayes Classifier");
            CBayesAlgorithm cBayesAlgorithm = new CBayesAlgorithm();
            datastore = new InMemoryBayesDatastore(params);
        }
        ClassifierContext classifier = new ClassifierContext((Algorithm)var18_22, datastore);
        classifier.initialize();
        String defaultCat = "unknown";
        if (cmdLine.hasOption((Option)defaultCatOpt)) {
            defaultCat = (String)cmdLine.getValue((Option)defaultCatOpt);
        }
        File docPath = new File((String)cmdLine.getValue((Option)classifyOpt));
        String encoding = "UTF-8";
        if (cmdLine.hasOption((Option)encodingOpt)) {
            encoding = (String)cmdLine.getValue((Option)encodingOpt);
        }
        StandardAnalyzer analyzer = null;
        if (cmdLine.hasOption((Option)analyzerOpt)) {
            String className = (String)cmdLine.getValue((Option)analyzerOpt);
            analyzer = Class.forName(className).asSubclass(Analyzer.class).newInstance();
        }
        if (analyzer == null) {
            analyzer = new StandardAnalyzer(Version.LUCENE_30);
        }
        log.info("Converting input document to proper format");
        String[] document = BayesFileFormatter.readerToDocument((Analyzer)analyzer, Files.newReader((File)docPath, (Charset)Charset.forName(encoding)));
        StringBuilder line = new StringBuilder();
        for (String token : document) {
            line.append(token).append(' ');
        }
        List<String> doc = new NGrams(line.toString(), gramSize).generateNGramsWithoutLabel();
        log.info("Done converting");
        log.info("Classifying document: {}", (Object)docPath);
        ClassifierResult category = classifier.classifyDocument(doc.toArray(new String[doc.size()]), defaultCat);
        log.info("Category for {} is {}", (Object)docPath, (Object)category);
    }
}

