/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.Version;
import org.apache.mahout.common.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BayesFileFormatter {
    private static final Logger log = LoggerFactory.getLogger(BayesFileFormatter.class);

    private BayesFileFormatter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void collapse(String label, Analyzer analyzer, File inputDir, Charset charset, File outputFile) throws IOException {
        BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)charset);
        try {
            inputDir.listFiles(new FileProcessor(label, analyzer, charset, writer));
        }
        catch (Throwable throwable) {
            IOUtils.quietClose(writer);
            throw throwable;
        }
        IOUtils.quietClose(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void format(String label, Analyzer analyzer, File input, Charset charset, File outDir) throws IOException {
        if (input.isDirectory()) {
            input.listFiles(new FileProcessor(label, analyzer, charset, outDir));
            return;
        }
        BufferedWriter writer = Files.newWriter((File)new File(outDir, input.getName()), (Charset)charset);
        try {
            BayesFileFormatter.writeFile(label, analyzer, input, charset, writer);
        }
        catch (Throwable throwable) {
            IOUtils.quietClose(writer);
            throw throwable;
        }
        IOUtils.quietClose(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String label, Analyzer analyzer, File inFile, Charset charset, Writer writer) throws IOException {
        BufferedReader reader = Files.newReader((File)inFile, (Charset)charset);
        try {
            TokenStream ts = analyzer.tokenStream(label, (Reader)reader);
            writer.write(label);
            writer.write(9);
            TermAttribute termAtt = (TermAttribute)ts.addAttribute(TermAttribute.class);
            while (ts.incrementToken()) {
                char[] termBuffer = termAtt.termBuffer();
                int termLen = termAtt.termLength();
                writer.write(termBuffer, 0, termLen);
                writer.write(32);
            }
        }
        catch (Throwable throwable) {
            IOUtils.quietClose(reader);
            throw throwable;
        }
        IOUtils.quietClose(reader);
    }

    public static String[] readerToDocument(Analyzer analyzer, Reader reader) throws IOException {
        TokenStream ts = analyzer.tokenStream("", reader);
        ArrayList<String> coll = new ArrayList<String>();
        TermAttribute termAtt = (TermAttribute)ts.addAttribute(TermAttribute.class);
        while (ts.incrementToken()) {
            char[] termBuffer = termAtt.termBuffer();
            int termLen = termAtt.termLength();
            String val = new String(termBuffer, 0, termLen);
            coll.add(val);
        }
        return coll.toArray(new String[coll.size()]);
    }

    public static void main(String[] args) throws Exception {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption inputOpt = obuilder.withLongName("input").withRequired(true).withArgument(abuilder.withName("input").withMinimum(1).withMaximum(1).create()).withDescription("The Input file").withShortName("i").create();
        DefaultOption outputOpt = obuilder.withLongName("output").withRequired(true).withArgument(abuilder.withName("output").withMinimum(1).withMaximum(1).create()).withDescription("The output file").withShortName("o").create();
        DefaultOption labelOpt = obuilder.withLongName("label").withRequired(true).withArgument(abuilder.withName("label").withMinimum(1).withMaximum(1).create()).withDescription("The label of the file").withShortName("l").create();
        DefaultOption analyzerOpt = obuilder.withLongName("analyzer").withArgument(abuilder.withName("analyzer").withMinimum(1).withMaximum(1).create()).withDescription("The fully qualified class name of the analyzer to use. Must have a no-arg constructor.  Default is the StandardAnalyzer").withShortName("a").create();
        DefaultOption charsetOpt = obuilder.withLongName("charset").withArgument(abuilder.withName("charset").withMinimum(1).withMaximum(1).create()).withDescription("The character encoding of the input file").withShortName("c").create();
        DefaultOption collapseOpt = obuilder.withLongName("collapse").withRequired(true).withArgument(abuilder.withName("collapse").withMinimum(1).withMaximum(1).create()).withDescription("Collapse a whole directory to a single file, one doc per line").withShortName("p").create();
        DefaultOption helpOpt = obuilder.withLongName("help").withDescription("Print out help").withShortName("h").create();
        Group group = gbuilder.withName("Options").withOption((Option)inputOpt).withOption((Option)outputOpt).withOption((Option)labelOpt).withOption((Option)analyzerOpt).withOption((Option)charsetOpt).withOption((Option)collapseOpt).withOption((Option)helpOpt).create();
        try {
            boolean collapse;
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption((Option)helpOpt)) {
                return;
            }
            File input = new File((String)cmdLine.getValue((Option)inputOpt));
            File output = new File((String)cmdLine.getValue((Option)outputOpt));
            String label = (String)cmdLine.getValue((Option)labelOpt);
            Object analyzer = cmdLine.hasOption((Option)analyzerOpt) ? Class.forName((String)cmdLine.getValue((Option)analyzerOpt)).asSubclass(Analyzer.class).newInstance() : new StandardAnalyzer(Version.LUCENE_30);
            Charset charset = Charsets.UTF_8;
            if (cmdLine.hasOption((Option)charsetOpt)) {
                charset = Charset.forName((String)cmdLine.getValue((Option)charsetOpt));
            }
            if (collapse = cmdLine.hasOption((Option)collapseOpt)) {
                BayesFileFormatter.collapse(label, (Analyzer)analyzer, input, charset, output);
            } else {
                BayesFileFormatter.format(label, (Analyzer)analyzer, input, charset, output);
            }
        }
        catch (OptionException e) {
            log.error("Exception", (Throwable)e);
        }
    }

    private static final class FileProcessor
    implements FileFilter {
        private final String label;
        private final Analyzer analyzer;
        private File outputDir;
        private final Charset charset;
        private Writer writer;

        private FileProcessor(String label, Analyzer analyzer, Charset charset, Writer writer) {
            this.label = label;
            this.analyzer = analyzer;
            this.charset = charset;
            this.writer = writer;
        }

        private FileProcessor(String label, Analyzer analyzer, Charset charset, File outputDir) {
            this.label = label;
            this.analyzer = analyzer;
            this.charset = charset;
            this.outputDir = outputDir;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean accept(File file) {
            if (file.isFile()) {
                Writer theWriter = null;
                try {
                    theWriter = this.writer == null ? Files.newWriter((File)new File(this.outputDir, file.getName()), (Charset)this.charset) : this.writer;
                    BayesFileFormatter.writeFile(this.label, this.analyzer, file, this.charset, theWriter);
                    if (this.writer != null) {
                        theWriter.write(10);
                    }
                    if (this.writer != null) return false;
                }
                catch (IOException e) {
                    try {
                        throw new IllegalStateException(e);
                    }
                    catch (Throwable throwable) {
                        if (this.writer != null) throw throwable;
                        IOUtils.quietClose(theWriter);
                        throw throwable;
                    }
                }
                IOUtils.quietClose(theWriter);
                return false;
            }
            file.listFiles(this);
            return false;
        }
    }
}

