/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.transforms;

import java.util.Collection;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.Cache;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverageAndStdDev;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.common.Retriever;
import org.apache.mahout.cf.taste.impl.common.RunningAverageAndStdDev;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.transforms.PreferenceTransform;

public final class ZScore
implements PreferenceTransform {
    private final DataModel dataModel;
    private final Cache<Long, RunningAverageAndStdDev> meanAndStdevs;

    public ZScore(DataModel dataModel) {
        this.dataModel = dataModel;
        this.meanAndStdevs = new Cache<Long, RunningAverageAndStdDev>(new MeanStdevRetriever());
        this.refresh(null);
    }

    @Override
    public float getTransformedValue(Preference pref) throws TasteException {
        double stdev;
        RunningAverageAndStdDev meanAndStdev = this.meanAndStdevs.get(pref.getUserID());
        if (meanAndStdev.getCount() > 1 && (stdev = meanAndStdev.getStandardDeviation()) > 0.0) {
            return (float)(((double)pref.getValue() - meanAndStdev.getAverage()) / stdev);
        }
        return 0.0f;
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.meanAndStdevs.clear();
        alreadyRefreshed = RefreshHelper.buildRefreshed(alreadyRefreshed);
        RefreshHelper.maybeRefresh(alreadyRefreshed, this.dataModel);
    }

    public String toString() {
        return "ZScore";
    }

    private class MeanStdevRetriever
    implements Retriever<Long, RunningAverageAndStdDev> {
        private MeanStdevRetriever() {
        }

        @Override
        public RunningAverageAndStdDev get(Long userID) throws TasteException {
            FullRunningAverageAndStdDev running = new FullRunningAverageAndStdDev();
            PreferenceArray prefs = ZScore.this.dataModel.getPreferencesFromUser(userID);
            int size = prefs.length();
            for (int i = 0; i < size; ++i) {
                running.addDatum(prefs.getValue(i));
            }
            return running;
        }
    }
}

